/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar.local;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.UserData;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.utils.IOUtils;

public class CacheAvatarLoader {
    public static void init() {
        LocalAvatarLoader.async(() -> {
            Path file = CacheAvatarLoader.getAvatarCacheDirectory();
            if (!Files.exists(file, new LinkOption[0]) || !Files.isDirectory(file, new LinkOption[0])) {
                return;
            }
            List<Path> children = IOUtils.listPaths(file);
            if (children == null) {
                return;
            }
            for (Path child : children) {
                try {
                    FileTime time = Files.getLastModifiedTime(child, new LinkOption[0]);
                    long diff = System.currentTimeMillis() - time.toMillis();
                    long elapsed = TimeUnit.MILLISECONDS.toDays(diff);
                    if (elapsed <= 7L) continue;
                    if (Files.deleteIfExists(child)) {
                        FiguraMod.debug("Successfully deleted cache avatar \"{}\" with \"{}\" days old", IOUtils.getFileNameOrEmpty(child), elapsed);
                        continue;
                    }
                    throw new Exception();
                }
                catch (Exception ignored) {
                    FiguraMod.debug("Failed to delete cache avatar \"{}\"", IOUtils.getFileNameOrEmpty(child));
                }
            }
        });
    }

    public static boolean checkAndLoad(String hash, UserData target) {
        Path p = CacheAvatarLoader.getAvatarCacheDirectory();
        if (Files.exists(p = p.resolve(hash + ".moon"), new LinkOption[0])) {
            CacheAvatarLoader.load(hash, target);
            return true;
        }
        return false;
    }

    public static void load(String hash, UserData target) {
        LocalAvatarLoader.async(() -> {
            Path path = CacheAvatarLoader.getAvatarCacheDirectory().resolve(hash + ".moon");
            try {
                target.loadAvatar(class_2507.method_10629((InputStream)Files.newInputStream(path, new OpenOption[0])));
                FiguraMod.debug("Loaded avatar \"{}\" from cache to \"{}\"", hash, target.id);
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to load cache avatar: " + hash, (Throwable)e);
            }
        });
    }

    public static void save(String hash, class_2487 nbt) {
        LocalAvatarLoader.async(() -> {
            Path file = CacheAvatarLoader.getAvatarCacheDirectory().resolve(hash + ".moon");
            try {
                class_2507.method_10634((class_2487)nbt, (OutputStream)Files.newOutputStream(file, new OpenOption[0]));
                FiguraMod.debug("Saved avatar \"{}\" on cache", hash);
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("Failed to save avatar on cache: " + hash, (Throwable)e);
            }
        });
    }

    public static void clearCache() {
        LocalAvatarLoader.async(() -> {
            Path file = CacheAvatarLoader.getAvatarCacheDirectory();
            if (!Files.exists(file, new LinkOption[0]) || !Files.isDirectory(file, new LinkOption[0])) {
                return;
            }
            List<Path> children = IOUtils.listPaths(file);
            if (children == null) {
                return;
            }
            for (Path child : children) {
                try {
                    if (Files.deleteIfExists(child)) continue;
                    throw new Exception();
                }
                catch (Exception ignored) {
                    FiguraMod.debug("Failed to delete cache avatar \"{}\"", IOUtils.getFileNameOrEmpty(child));
                }
            }
            FiguraMod.debug("Finished clearing avatar cache", new Object[0]);
        });
    }

    public static Path getAvatarCacheDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getCacheDirectory(), "avatars");
    }
}

