/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.avatar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.class_1007;
import net.minecraft.class_1011;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4228;
import net.minecraft.class_4231;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_922;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.animation.Animation;
import org.figuramc.figura.animation.AnimationPlayer;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.lua.FiguraLuaPrinter;
import org.figuramc.figura.lua.FiguraLuaRuntime;
import org.figuramc.figura.lua.api.data.FiguraBuffer;
import org.figuramc.figura.lua.api.entity.EntityAPI;
import org.figuramc.figura.lua.api.particle.ParticleAPI;
import org.figuramc.figura.lua.api.ping.PingArg;
import org.figuramc.figura.lua.api.ping.PingFunction;
import org.figuramc.figura.lua.api.sound.SoundAPI;
import org.figuramc.figura.lua.api.world.BlockStateAPI;
import org.figuramc.figura.lua.api.world.ItemStackAPI;
import org.figuramc.figura.math.matrix.FiguraMat3;
import org.figuramc.figura.math.matrix.FiguraMat4;
import org.figuramc.figura.math.vector.FiguraVec3;
import org.figuramc.figura.model.FiguraModelPart;
import org.figuramc.figura.model.ParentType;
import org.figuramc.figura.model.PartCustomization;
import org.figuramc.figura.model.rendering.AvatarRenderer;
import org.figuramc.figura.model.rendering.EntityRenderMode;
import org.figuramc.figura.model.rendering.ImmediateAvatarRenderer;
import org.figuramc.figura.model.rendering.PartFilterScheme;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.PermissionPack;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.EntityUtils;
import org.figuramc.figura.utils.PathUtils;
import org.figuramc.figura.utils.RefilledNumber;
import org.figuramc.figura.utils.Version;
import org.figuramc.figura.utils.ui.UIHelper;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;

public class Avatar {
    private static CompletableFuture<Void> tasks;
    public static boolean firstPerson;
    public final UUID owner;
    public final class_1299<?> entityType;
    public class_2487 nbt;
    public boolean loaded = true;
    public final boolean isHost;
    public String name;
    public String entityName;
    public String authors;
    public Version version;
    public String id;
    public int fileSize;
    public String color;
    public Map<String, String> badgeToColor = new HashMap<String, String>();
    public Map<String, byte[]> resources = new HashMap<String, byte[]>();
    public boolean minify;
    private final Queue<Runnable> events = new ConcurrentLinkedQueue<Runnable>();
    public final ArrayList<FiguraBuffer> openBuffers = new ArrayList();
    public AvatarRenderer renderer;
    public FiguraLuaRuntime luaRuntime;
    public EntityRenderMode renderMode = EntityRenderMode.OTHER;
    public final PermissionPack.PlayerPermissionPack permissions;
    public final Map<String, class_4231> customSounds = new HashMap<String, class_4231>();
    public final Map<Integer, Animation> animations = new HashMap<Integer, Animation>();
    public boolean hasTexture;
    public boolean scriptError;
    public class_2561 errorText;
    public Set<Permissions> noPermissions = new HashSet<Permissions>();
    public Set<Permissions> permissionsToTick = new HashSet<Permissions>();
    public int lastPlayingSound = 0;
    public int versionStatus = 0;
    public int animationComplexity;
    public final Instructions complexity;
    public final Instructions init;
    public final Instructions render;
    public final Instructions worldRender;
    public final Instructions tick;
    public final Instructions worldTick;
    public final Instructions animation;
    public final RefilledNumber particlesRemaining;
    public final RefilledNumber soundsRemaining;
    private static final PartCustomization PIVOT_PART_RENDERING_CUSTOMIZATION;

    private Avatar(UUID owner, class_1299<?> type, String name) {
        this.owner = owner;
        this.entityType = type;
        this.isHost = type == class_1299.field_6097 && FiguraMod.isLocal(owner);
        this.permissions = type == class_1299.field_6097 ? PermissionManager.get(owner) : PermissionManager.getMobPermissions(owner);
        this.complexity = new Instructions(this.permissions.get(Permissions.COMPLEXITY));
        this.init = new Instructions(this.permissions.get(Permissions.INIT_INST));
        this.render = new Instructions(this.permissions.get(Permissions.RENDER_INST));
        this.worldRender = new Instructions(this.permissions.get(Permissions.WORLD_RENDER_INST));
        this.tick = new Instructions(this.permissions.get(Permissions.TICK_INST));
        this.worldTick = new Instructions(this.permissions.get(Permissions.WORLD_TICK_INST));
        this.animation = new Instructions(this.permissions.get(Permissions.ANIMATION_INST));
        this.particlesRemaining = new RefilledNumber(this.permissions.get(Permissions.PARTICLES));
        this.soundsRemaining = new RefilledNumber(this.permissions.get(Permissions.SOUNDS));
        this.entityName = name == null ? "" : name;
    }

    public Avatar(UUID owner) {
        this(owner, class_1299.field_6097, EntityUtils.getNameForUUID(owner));
    }

    public Avatar(class_1297 entity) {
        this(entity.method_5667(), entity.method_5864(), entity.method_5477().getString());
    }

    public void load(class_2487 nbt) {
        Runnable toRun = () -> {
            this.nbt = nbt;
            this.loaded = false;
        };
        if (tasks == null || tasks.isDone()) {
            tasks = CompletableFuture.runAsync(toRun);
        } else {
            tasks.thenRun(toRun);
        }
        tasks.join();
        if (nbt == null) {
            this.loaded = true;
            return;
        }
        tasks.thenRun(() -> {
            try {
                class_2487 metadata = nbt.method_10562("metadata");
                this.name = metadata.method_10558("name");
                this.authors = metadata.method_10558("authors");
                this.version = new Version(metadata.method_10558("ver"));
                if (metadata.method_10545("id")) {
                    this.id = metadata.method_10558("id");
                }
                if (metadata.method_10545("color")) {
                    this.color = metadata.method_10558("color");
                }
                if (metadata.method_10545("minify")) {
                    this.minify = metadata.method_10577("minify");
                }
                if (nbt.method_10545("resources")) {
                    class_2487 res = nbt.method_10562("resources");
                    for (String k : res.method_10541()) {
                        this.resources.put(k, res.method_10547(k));
                    }
                }
                for (String key : metadata.method_10541()) {
                    if (!key.contains("badge_color_")) continue;
                    this.badgeToColor.put(key.replace("badge_color_", ""), metadata.method_10558(key));
                }
                this.fileSize = this.getFileSize();
                this.versionStatus = this.getVersionStatus();
                if (this.entityName.isBlank()) {
                    this.entityName = this.name;
                }
                this.loadAnimations();
                this.renderer = new ImmediateAvatarRenderer(this);
                this.loadCustomSounds();
                this.createLuaRuntime();
            }
            catch (Exception e) {
                FiguraMod.LOGGER.error("", (Throwable)e);
                this.clean();
                this.nbt = null;
                this.renderer = null;
                this.luaRuntime = null;
            }
            this.loaded = true;
        });
    }

    public void tick() {
        class_1297 entity;
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return;
        }
        if (this.luaRuntime.getUser() == null && (entity = EntityUtils.getEntityByUUID(this.owner)) != null) {
            this.luaRuntime.setUser(entity);
            this.run("ENTITY_INIT", this.init.post(), new Object[0]);
        }
        for (Permissions t : this.permissionsToTick) {
            if (this.permissions.get(t) > 0) {
                this.noPermissions.remove(t);
                continue;
            }
            this.noPermissions.add(t);
        }
        if (this.lastPlayingSound > 0) {
            --this.lastPlayingSound;
        }
        this.particlesRemaining.set(this.permissions.get(Permissions.PARTICLES));
        this.particlesRemaining.tick();
        this.soundsRemaining.set(this.permissions.get(Permissions.SOUNDS));
        this.soundsRemaining.tick();
        FiguraMod.pushProfiler("worldTick");
        this.worldTick.reset(this.permissions.get(Permissions.WORLD_TICK_INST));
        this.run("WORLD_TICK", this.worldTick, new Object[0]);
        FiguraMod.popPushProfiler("tick");
        this.tick.reset(this.permissions.get(Permissions.TICK_INST));
        this.tickEvent();
        FiguraMod.popProfiler();
    }

    public void render(float delta) {
        if (this.complexity.remaining <= 0) {
            this.noPermissions.add(Permissions.COMPLEXITY);
        } else {
            this.noPermissions.remove(Permissions.COMPLEXITY);
        }
        this.complexity.reset(this.permissions.get(Permissions.COMPLEXITY));
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return;
        }
        this.render.reset(this.permissions.get(Permissions.RENDER_INST));
        this.worldRender.reset(this.permissions.get(Permissions.WORLD_RENDER_INST));
        this.run("WORLD_RENDER", this.worldRender, Float.valueOf(delta));
    }

    public void runPing(int id, byte[] data) {
        this.events.offer(() -> {
            if (this.scriptError || this.luaRuntime == null || !this.loaded) {
                return;
            }
            LuaValue[] args = PingArg.fromByteArray(data, this);
            String name = this.luaRuntime.ping.getName(id);
            PingFunction function = this.luaRuntime.ping.get(name);
            if (args == null || function == null) {
                return;
            }
            FiguraLuaPrinter.sendPingMessage(this, name, data.length, args);
            this.luaRuntime.run(function.func, this.tick, args);
        });
    }

    public LuaValue loadScript(String name, String chunk) {
        return this.scriptError || this.luaRuntime == null || !this.loaded ? null : this.luaRuntime.load(name, chunk);
    }

    private void flushQueuedEvents() {
        Runnable e;
        while ((e = this.events.poll()) != null) {
            try {
                e.run();
            }
            catch (Exception | StackOverflowError ex) {
                if (this.luaRuntime == null) continue;
                this.luaRuntime.error(ex);
            }
        }
    }

    @Nullable
    public Varargs run(Object toRun, Instructions limit, Object ... args) {
        this.flushQueuedEvents();
        if (this.scriptError || this.luaRuntime == null || !this.loaded) {
            return null;
        }
        Varargs ret = this.luaRuntime.run(toRun, limit, args);
        this.flushQueuedEvents();
        return ret;
    }

    public void punish(int amount) {
        if (this.luaRuntime != null) {
            this.luaRuntime.takeInstructions(amount);
        }
    }

    private boolean isCancelled(Varargs args) {
        if (args == null) {
            return false;
        }
        for (int i = 1; i <= args.narg(); ++i) {
            if (!args.arg(i).isboolean() || !args.arg(i).checkboolean()) continue;
            return true;
        }
        return false;
    }

    public void tickEvent() {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("TICK", this.tick, new Object[0]);
        }
    }

    public void renderEvent(float delta, FiguraMat4 poseMatrix) {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("RENDER", this.render, Float.valueOf(delta), this.renderMode.name(), poseMatrix);
        }
    }

    public void postRenderEvent(float delta, FiguraMat4 poseMatrix) {
        if (this.loaded && this.luaRuntime != null && this.luaRuntime.getUser() != null) {
            this.run("POST_RENDER", this.render.post(), Float.valueOf(delta), this.renderMode.name(), poseMatrix);
        }
        this.renderMode = EntityRenderMode.OTHER;
    }

    public void postWorldRenderEvent(float delta) {
        if (!this.loaded) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.allowMatrixUpdate = false;
        }
        this.run("POST_WORLD_RENDER", this.worldRender.post(), Float.valueOf(delta));
    }

    public boolean skullRenderEvent(float delta, BlockStateAPI block, ItemStackAPI item, EntityAPI<?> entity, String mode) {
        Varargs result = null;
        if (this.loaded && this.renderer != null && this.renderer.interceptRendersIntoFigura) {
            result = this.run("SKULL_RENDER", this.render, Float.valueOf(delta), block, item, entity, mode);
        }
        return this.isCancelled(result);
    }

    public boolean useItemEvent(ItemStackAPI stack, String type, int particleCount) {
        Varargs result = this.loaded ? this.run("USE_ITEM", this.tick, stack, type, particleCount) : null;
        return this.isCancelled(result);
    }

    public boolean arrowRenderEvent(float delta, EntityAPI<?> arrow) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("ARROW_RENDER", this.render, Float.valueOf(delta), arrow);
        }
        return this.isCancelled(result);
    }

    public boolean tridentRenderEvent(float delta, EntityAPI<?> trident) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("TRIDENT_RENDER", this.render, Float.valueOf(delta), trident);
        }
        return this.isCancelled(result);
    }

    public boolean itemRenderEvent(ItemStackAPI item, String mode, FiguraVec3 pos, FiguraVec3 rot, FiguraVec3 scale, boolean leftHanded, class_4587 stack, class_4597 bufferSource, int light, int overlay) {
        if (!this.loaded || this.renderer == null || !this.renderer.interceptRendersIntoFigura) {
            return false;
        }
        Varargs result = this.run("ITEM_RENDER", this.render, item, mode, pos, rot, scale, leftHanded);
        if (result == null) {
            return false;
        }
        boolean rendered = false;
        for (int i = 1; i <= result.narg(); ++i) {
            if (!result.arg(i).isuserdata(FiguraModelPart.class)) continue;
            rendered |= this.renderItem(stack, bufferSource, (FiguraModelPart)result.arg(i).checkuserdata(FiguraModelPart.class), light, overlay);
        }
        return rendered;
    }

    public boolean playSoundEvent(String id, FiguraVec3 pos, float vol, float pitch, boolean loop, String category, String file) {
        Varargs result = null;
        if (this.loaded) {
            result = this.run("ON_PLAY_SOUND", this.tick, id, pos, Float.valueOf(vol), Float.valueOf(pitch), loop, category, file);
        }
        return this.isCancelled(result);
    }

    public void resourceReloadEvent() {
        if (this.loaded) {
            this.run("RESOURCE_RELOAD", this.tick, new Object[0]);
        }
    }

    public String chatSendMessageEvent(String message) {
        Varargs val;
        Varargs varargs = val = this.loaded ? this.run("CHAT_SEND_MESSAGE", this.tick, message) : null;
        return val == null || !val.isnil(1) && (Boolean)Configs.CHAT_MESSAGES.value == false ? message : (val.isnil(1) ? "" : val.arg(1).tojstring());
    }

    public Pair<String, Integer> chatReceivedMessageEvent(String message, String json) {
        Varargs val;
        Varargs varargs = val = this.loaded ? this.run("CHAT_RECEIVE_MESSAGE", this.tick, message, json) : null;
        if (val == null) {
            return null;
        }
        if (val.arg(1).isboolean() && !val.arg(1).checkboolean()) {
            return Pair.of(null, null);
        }
        String msg = val.isnil(1) ? json : val.arg(1).tojstring();
        Integer color = null;
        if (val.arg(2).isuserdata(FiguraVec3.class)) {
            color = ColorUtils.rgbToInt((FiguraVec3)val.arg(2).checkuserdata(FiguraVec3.class));
        }
        return Pair.of((Object)msg, color);
    }

    public boolean mouseScrollEvent(double delta) {
        Varargs result = this.loaded ? this.run("MOUSE_SCROLL", this.tick, delta) : null;
        return this.isCancelled(result);
    }

    public boolean mouseMoveEvent(double x, double y) {
        Varargs result = this.loaded ? this.run("MOUSE_MOVE", this.tick, x, y) : null;
        return this.isCancelled(result);
    }

    public boolean mousePressEvent(int button, int action, int modifiers) {
        Varargs result = this.loaded ? this.run("MOUSE_PRESS", this.tick, button, action, modifiers) : null;
        return this.isCancelled(result);
    }

    public boolean keyPressEvent(int key, int action, int modifiers) {
        Varargs result = this.loaded ? this.run("KEY_PRESS", this.tick, key, action, modifiers) : null;
        return this.isCancelled(result);
    }

    public void charTypedEvent(String chars, int modifiers, int codePoint) {
        if (this.loaded) {
            this.run("CHAR_TYPED", this.tick, chars, modifiers, codePoint);
        }
    }

    private void render() {
        if (this.renderMode == EntityRenderMode.RENDER || this.renderMode == EntityRenderMode.FIRST_PERSON) {
            this.complexity.use(this.renderer.render());
            return;
        }
        int prev = this.complexity.remaining;
        this.complexity.remaining = this.permissions.get(Permissions.COMPLEXITY);
        this.renderer.render();
        this.complexity.remaining = prev;
    }

    public void render(class_1297 entity, float yaw, float delta, float alpha, class_4587 stack, class_4597 bufferSource, int light, int overlay, class_922<?, ?> entityRenderer, PartFilterScheme filter, boolean translucent, boolean glowing) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        this.renderer.vanillaModelData.update(entityRenderer);
        this.renderer.yaw = yaw;
        this.renderer.entity = entity;
        this.renderer.setupRenderer(filter, bufferSource, stack, delta, light, alpha, overlay, translucent, glowing);
        this.render();
    }

    public synchronized void worldRender(class_1297 entity, double camX, double camY, double camZ, class_4587 stack, class_4597 bufferSource, int lightFallback, float tickDelta, EntityRenderMode mode) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        EntityRenderMode prevRenderMode = this.renderMode;
        this.renderMode = mode;
        boolean update = prevRenderMode != EntityRenderMode.OTHER || this.renderMode == EntityRenderMode.FIRST_PERSON_WORLD;
        this.renderer.pivotCustomizations.values().clear();
        this.renderer.allowMatrixUpdate = this.renderer.updateLight = update;
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.WORLD, bufferSource, stack, tickDelta, lightFallback, 1.0f, class_4608.field_21444, false, false, camX, camY, camZ);
        this.complexity.use(this.renderer.renderSpecialParts());
        this.renderMode = prevRenderMode;
        this.renderer.updateLight = false;
    }

    public void capeRender(class_1297 entity, class_4597 bufferSource, class_4587 stack, int light, float tickDelta, class_630 cloak) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("capeRender");
        this.renderer.vanillaModelData.update(ParentType.Cape, cloak);
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.CAPE, bufferSource, stack, tickDelta, light, 1.0f, class_4608.field_21444, this.renderer.translucent, this.renderer.glowing);
        this.render();
        FiguraMod.popProfiler(3);
    }

    public void elytraRender(class_1297 entity, class_4597 bufferSource, class_4587 stack, int light, float tickDelta, class_583<?> model) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("elytraRender");
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.LEFT_ELYTRA, bufferSource, stack, tickDelta, light, 1.0f, class_4608.field_21444, this.renderer.translucent, this.renderer.glowing);
        FiguraMod.pushProfiler("leftWing");
        this.renderer.vanillaModelData.update(ParentType.LeftElytra, model);
        this.renderer.renderSpecialParts();
        FiguraMod.popPushProfiler("rightWing");
        this.renderer.vanillaModelData.update(ParentType.RightElytra, model);
        this.renderer.currentFilterScheme = PartFilterScheme.RIGHT_ELYTRA;
        this.renderer.renderSpecialParts();
        FiguraMod.popProfiler(4);
    }

    public void firstPersonWorldRender(class_1297 watcher, class_4597 bufferSource, class_4587 matrices, class_4184 camera, float tickDelta) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("firstPersonWorldRender");
        int light = class_310.method_1551().method_1561().method_23839(watcher, tickDelta);
        class_243 camPos = camera.method_19326();
        this.worldRender(watcher, camPos.field_1352, camPos.field_1351, camPos.field_1350, matrices, bufferSource, light, tickDelta, EntityRenderMode.FIRST_PERSON_WORLD);
        FiguraMod.popProfiler(3);
    }

    public void firstPersonRender(class_4587 stack, class_4597 bufferSource, class_1657 player, class_1007 playerRenderer, class_630 arm, int light, float tickDelta) {
        boolean config;
        if (this.renderer == null || !this.loaded) {
            return;
        }
        boolean lefty = arm == ((class_591)playerRenderer.method_4038()).field_27433;
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("firstPersonRender");
        FiguraMod.pushProfiler(lefty ? "leftArm" : "rightArm");
        PartFilterScheme filter = lefty ? PartFilterScheme.LEFT_ARM : PartFilterScheme.RIGHT_ARM;
        this.renderer.allowHiddenTransforms = config = ((Boolean)Configs.ALLOW_FP_HANDS.value).booleanValue();
        this.renderer.allowMatrixUpdate = false;
        this.renderer.ignoreVanillaVisibility = true;
        stack.method_22903();
        if (!config) {
            stack.method_22907(class_1160.field_20707.method_23626(arm.field_3674));
            stack.method_22907(class_1160.field_20705.method_23626(arm.field_3675));
            stack.method_22907(class_1160.field_20703.method_23626(arm.field_3654));
        }
        this.render((class_1297)player, 0.0f, tickDelta, 1.0f, stack, bufferSource, light, class_4608.field_21444, (class_922<?, ?>)playerRenderer, filter, false, false);
        stack.method_22909();
        this.renderer.allowHiddenTransforms = true;
        this.renderer.ignoreVanillaVisibility = false;
        FiguraMod.popProfiler(4);
    }

    public void hudRender(class_4587 stack, class_4597 bufferSource, class_1297 entity, float tickDelta) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("hudRender");
        stack.method_22903();
        stack.method_23760().method_23761().method_22672(class_1159.method_24019((float)16.0f, (float)16.0f, (float)-16.0f));
        stack.method_23760().method_23762().method_22855(class_4581.method_23963((float)1.0f, (float)1.0f, (float)-1.0f));
        class_308.method_24210();
        RenderSystem.disableDepthTest();
        this.renderer.entity = entity;
        this.renderer.setupRenderer(PartFilterScheme.HUD, bufferSource, stack, tickDelta, 0xF000F0, 1.0f, class_4608.field_21444, false, false);
        if (this.renderer.renderSpecialParts() > 0) {
            ((class_4597.class_4598)this.renderer.bufferSource).method_22993();
        }
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        stack.method_22909();
        FiguraMod.popProfiler(2);
    }

    public boolean skullRender(class_4587 stack, class_4597 bufferSource, int light, class_2350 direction, float yaw) {
        if (this.renderer == null || !this.loaded || !this.renderer.interceptRendersIntoFigura) {
            return false;
        }
        stack.method_22903();
        if (direction == null) {
            stack.method_22904(0.5, 0.0, 0.5);
        } else {
            stack.method_22904(0.5 - (double)direction.method_10148() * 0.25, 0.25, 0.5 - (double)direction.method_10165() * 0.25);
        }
        stack.method_22905(-1.0f, -1.0f, 1.0f);
        stack.method_22907(class_1160.field_20705.method_23214(yaw));
        this.renderer.allowPivotParts = false;
        this.renderer.setupRenderer(PartFilterScheme.SKULL, bufferSource, stack, 1.0f, light, 1.0f, class_4608.field_21444, false, false);
        int comp = this.renderer.renderSpecialParts();
        this.complexity.use(comp);
        boolean bool = comp > 0 || this.headRender(stack, bufferSource, light, true);
        this.renderer.allowPivotParts = true;
        stack.method_22909();
        return bool;
    }

    public boolean headRender(class_4587 stack, class_4597 bufferSource, int light, boolean useComplexity) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        boolean oldMat = this.renderer.allowMatrixUpdate;
        this.renderer.setupRenderer(PartFilterScheme.HEAD, bufferSource, stack, 1.0f, light, 1.0f, class_4608.field_21444, false, false);
        this.renderer.allowHiddenTransforms = false;
        this.renderer.allowMatrixUpdate = false;
        this.renderer.ignoreVanillaVisibility = true;
        int comp = this.renderer.render();
        if (useComplexity) {
            this.complexity.use(comp);
        }
        this.renderer.allowMatrixUpdate = oldMat;
        this.renderer.allowHiddenTransforms = true;
        this.renderer.ignoreVanillaVisibility = false;
        return comp > 0 && this.luaRuntime != null && !this.luaRuntime.vanilla_model.HEAD.checkVisible();
    }

    public boolean renderPortrait(class_4587 pose, int x, int y, int size, float modelScale, boolean upsideDown) {
        if (!((Boolean)Configs.AVATAR_PORTRAIT.value).booleanValue() || this.renderer == null || !this.loaded) {
            return false;
        }
        pose.method_22903();
        pose.method_22904((double)x, (double)y, 0.0);
        pose.method_22905(modelScale, modelScale * (float)(upsideDown ? 1 : -1), modelScale);
        pose.method_22907(class_1160.field_20703.method_23214(180.0f));
        FiguraVec3 pos = FiguraMat4.of().set(pose.method_23760().method_23761()).apply(0.0, 0.0, 0.0);
        int x1 = (int)pos.x;
        int y1 = (int)pos.y;
        int x2 = (int)pos.x + size;
        int y2 = (int)pos.y + size;
        UIHelper.setupScissor(x1, y1, x2 - x1, y2 - y1);
        UIHelper.paperdoll = true;
        UIHelper.dollScale = 16.0f;
        pose.method_22904(0.25, upsideDown ? 0.0 : 0.5, 0.0);
        class_308.method_24210();
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        int light = 0xF000F0;
        this.renderer.allowPivotParts = false;
        this.renderer.setupRenderer(PartFilterScheme.PORTRAIT, (class_4597)buffer, pose, 1.0f, light, 1.0f, class_4608.field_21444, false, false);
        int comp = this.renderer.renderSpecialParts();
        boolean ret = comp > 0 || this.headRender(pose, (class_4597)buffer, light, false);
        buffer.method_22993();
        pose.method_22909();
        UIHelper.disableScissor();
        UIHelper.paperdoll = false;
        this.renderer.allowPivotParts = true;
        return ret;
    }

    public boolean renderArrow(class_4587 stack, class_4597 bufferSource, float delta, int light) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        stack.method_22903();
        class_1158 quaternionf = class_1160.field_20703.method_23214(135.0f);
        class_1158 quaternionf2 = class_1160.field_20705.method_23214(-90.0f);
        quaternionf.method_4925(quaternionf2);
        stack.method_22907(quaternionf);
        this.renderer.setupRenderer(PartFilterScheme.ARROW, bufferSource, stack, delta, light, 1.0f, class_4608.field_21444, false, false);
        int comp = this.renderer.renderSpecialParts();
        stack.method_22909();
        return comp > 0;
    }

    public boolean renderTrident(class_4587 stack, class_4597 bufferSource, float delta, int light) {
        if (this.renderer == null || !this.loaded) {
            return false;
        }
        stack.method_22903();
        class_1158 quaternionf = class_1160.field_20707.method_23214(90.0f);
        class_1158 quaternionf2 = class_1160.field_20705.method_23214(90.0f);
        quaternionf.method_4925(quaternionf2);
        stack.method_22907(quaternionf);
        this.renderer.setupRenderer(PartFilterScheme.TRIDENT, bufferSource, stack, delta, light, 1.0f, class_4608.field_21444, false, false);
        int comp = this.renderer.renderSpecialParts();
        stack.method_22909();
        return comp > 0;
    }

    public boolean renderItem(class_4587 stack, class_4597 bufferSource, FiguraModelPart part, int light, int overlay) {
        if (this.renderer == null || !this.loaded || part.parentType != ParentType.Item) {
            return false;
        }
        stack.method_22903();
        stack.method_22907(class_1160.field_20707.method_23214(180.0f));
        this.renderer.setupRenderer(PartFilterScheme.ITEM, bufferSource, stack, 1.0f, light, 1.0f, overlay, false, false);
        this.renderer.itemToRender = part;
        int ret = this.renderer.renderSpecialParts();
        stack.method_22909();
        return ret > 0;
    }

    public synchronized boolean pivotPartRender(ParentType parent, Consumer<class_4587> consumer) {
        if (this.renderer == null || !this.loaded || !parent.isPivot) {
            return false;
        }
        Queue queue = this.renderer.pivotCustomizations.computeIfAbsent(parent, p -> new ConcurrentLinkedQueue());
        if (queue.isEmpty()) {
            return false;
        }
        int i = 0;
        while (!queue.isEmpty() && i++ < 1000) {
            Pair matrixPair = (Pair)queue.poll();
            PIVOT_PART_RENDERING_CUSTOMIZATION.setPositionMatrix((FiguraMat4)matrixPair.getFirst());
            PIVOT_PART_RENDERING_CUSTOMIZATION.setNormalMatrix((FiguraMat3)matrixPair.getSecond());
            Avatar.PIVOT_PART_RENDERING_CUSTOMIZATION.needsMatrixRecalculation = false;
            class_4587 stack = PIVOT_PART_RENDERING_CUSTOMIZATION.copyIntoGlobalPoseStack();
            consumer.accept(stack);
        }
        queue.clear();
        return true;
    }

    public void updateMatrices(class_922<?, ?> entityRenderer, class_4587 stack) {
        if (this.renderer == null || !this.loaded) {
            return;
        }
        FiguraMod.pushProfiler("figura");
        FiguraMod.pushProfiler(this);
        FiguraMod.pushProfiler("updateMatrices");
        this.renderer.vanillaModelData.update(entityRenderer);
        this.renderer.currentFilterScheme = PartFilterScheme.MODEL;
        this.renderer.setMatrices(stack);
        this.renderer.updateMatrices();
        FiguraMod.popProfiler(3);
    }

    public void applyAnimations() {
        int animationsLimit;
        if (!this.loaded || this.scriptError) {
            return;
        }
        this.animation.reset(this.permissions.get(Permissions.ANIMATION_INST));
        int limit = animationsLimit = this.permissions.get(Permissions.BB_ANIMATIONS);
        for (Animation animation : this.animations.values()) {
            limit = AnimationPlayer.tick(animation, limit);
        }
        this.animationComplexity = animationsLimit - limit;
        if (limit <= 0) {
            this.noPermissions.add(Permissions.BB_ANIMATIONS);
        } else {
            this.noPermissions.remove(Permissions.BB_ANIMATIONS);
        }
    }

    public void clearAnimations() {
        if (!this.loaded || this.scriptError) {
            return;
        }
        for (Animation animation : this.animations.values()) {
            AnimationPlayer.clear(animation);
        }
    }

    public void clean() {
        if (this.renderer != null) {
            this.renderer.invalidate();
        }
        this.clearSounds();
        this.clearParticles();
        this.closeBuffers();
        this.events.clear();
    }

    public void clearSounds() {
        SoundAPI.getSoundEngine().figura$stopSound(this.owner, null);
        for (class_4231 value : this.customSounds.values()) {
            value.method_19688();
        }
    }

    public void closeBuffers() {
        for (FiguraBuffer buffer : this.openBuffers) {
            if (buffer.isClosed()) continue;
            try {
                buffer.baseClose();
            }
            catch (Exception exception) {}
        }
        this.openBuffers.clear();
    }

    public void clearParticles() {
        ParticleAPI.getParticleEngine().figura$clearParticles(this.owner);
    }

    private int getFileSize() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            class_2507.method_10634((class_2487)this.nbt, (OutputStream)baos);
            return baos.size();
        }
        catch (Exception e) {
            FiguraMod.LOGGER.warn("Failed to generate file size for model " + this.name, (Throwable)e);
            return 0;
        }
    }

    private int getVersionStatus() {
        if (this.version == null || NetworkStuff.latestVersion != null && this.version.compareTo(NetworkStuff.latestVersion) > 0) {
            return 0;
        }
        return this.version.compareTo(FiguraMod.VERSION);
    }

    private void createLuaRuntime() {
        if (!this.nbt.method_10545("scripts")) {
            return;
        }
        HashMap<String, String> scripts = new HashMap<String, String>();
        class_2487 scriptsNbt = this.nbt.method_10562("scripts");
        for (String s : scriptsNbt.method_10541()) {
            scripts.put(PathUtils.computeSafeString(s), new String(scriptsNbt.method_10547(s), StandardCharsets.UTF_8));
        }
        class_2487 metadata = this.nbt.method_10562("metadata");
        class_2499 autoScripts = metadata.method_10545("autoScripts") ? metadata.method_10554("autoScripts", 8) : null;
        FiguraLuaRuntime runtime = new FiguraLuaRuntime(this, scripts);
        if (this.renderer != null && this.renderer.root != null) {
            runtime.setGlobal("models", this.renderer.root);
        }
        this.init.reset(this.permissions.get(Permissions.INIT_INST));
        runtime.setInstructionLimit(this.init.remaining);
        this.events.offer(() -> {
            if (runtime.init(autoScripts)) {
                this.init.use(runtime.getInstructions());
            }
        });
    }

    private void loadAnimations() {
        if (!this.nbt.method_10545("animations")) {
            return;
        }
        ArrayList<String> autoAnims = new ArrayList<String>();
        class_2487 metadata = this.nbt.method_10562("metadata");
        if (metadata.method_10545("autoAnims")) {
            for (class_2520 name : metadata.method_10554("autoAnims", 8)) {
                autoAnims.add(name.method_10714());
            }
        }
        class_2499 root = this.nbt.method_10554("animations", 10);
        for (int i = 0; i < root.size(); ++i) {
            try {
                class_2487 animNbt = root.method_10602(i);
                if (!animNbt.method_10545("mdl") || !animNbt.method_10545("name")) continue;
                String mdl = animNbt.method_10558("mdl");
                String name = animNbt.method_10558("name");
                Animation.LoopMode loop = Animation.LoopMode.ONCE;
                if (animNbt.method_10545("loop")) {
                    try {
                        loop = Animation.LoopMode.valueOf(animNbt.method_10558("loop").toUpperCase(Locale.US));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Animation animation = new Animation(this, mdl, name, loop, animNbt.method_10545("ovr") && animNbt.method_10577("ovr"), animNbt.method_10545("len") ? animNbt.method_10583("len") : 0.0f, animNbt.method_10545("off") ? animNbt.method_10583("off") : 0.0f, animNbt.method_10545("bld") ? animNbt.method_10583("bld") : 1.0f, animNbt.method_10545("sdel") ? animNbt.method_10583("sdel") : 0.0f, animNbt.method_10545("ldel") ? animNbt.method_10583("ldel") : 0.0f);
                if (animNbt.method_10545("code")) {
                    for (class_2520 code : animNbt.method_10554("code", 10)) {
                        class_2487 compound = (class_2487)code;
                        animation.newCode(compound.method_10583("time"), compound.method_10558("src"));
                    }
                }
                this.animations.put(i, animation);
                if (!autoAnims.contains(mdl + "." + name)) continue;
                animation.play();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadCustomSounds() {
        if (!this.nbt.method_10545("sounds")) {
            return;
        }
        class_2487 root = this.nbt.method_10562("sounds");
        for (String key : root.method_10541()) {
            try {
                this.loadSound(key, root.method_10547(key));
            }
            catch (Exception e) {
                FiguraMod.LOGGER.warn("Failed to load custom sound \"" + key + "\"", (Throwable)e);
            }
        }
    }

    public void loadSound(String name, byte[] data) throws Exception {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
             class_4228 oggAudioStream = new class_4228((InputStream)inputStream);){
            class_4231 sound = new class_4231(oggAudioStream.method_19721(), oggAudioStream.method_19719());
            this.customSounds.put(name, sound);
        }
    }

    public FiguraTexture registerTexture(String name, class_1011 image, boolean ignoreSize) {
        int max = this.permissions.get(Permissions.TEXTURE_SIZE);
        if (!(ignoreSize || image.method_4307() <= max && image.method_4323() <= max)) {
            this.noPermissions.add(Permissions.TEXTURE_SIZE);
            throw new LuaError("Texture exceeded max size of " + max + " x " + max + " resolution, got " + image.method_4307() + " x " + image.method_4323());
        }
        FiguraTexture oldText = this.renderer.customTextures.get(name);
        if (oldText != null) {
            oldText.close();
        }
        if (this.renderer.customTextures.size() > 128) {
            throw new LuaError("Maximum amount of textures reached!");
        }
        FiguraTexture texture = new FiguraTexture(this, name, image);
        this.renderer.customTextures.put(name, texture);
        return texture;
    }

    static {
        PIVOT_PART_RENDERING_CUSTOMIZATION = new PartCustomization();
    }

    public static class Instructions {
        public int max;
        public int remaining;
        private int currPre;
        private int currPost;
        public int pre;
        public int post;
        private boolean inverted;

        public Instructions(int remaining) {
            this.reset(remaining);
        }

        public Instructions post() {
            this.inverted = true;
            return this;
        }

        public int getTotal() {
            return this.pre + this.post;
        }

        public void reset(int remaining) {
            this.max = this.remaining = remaining;
            this.currPost = 0;
            this.currPre = 0;
        }

        public void use(int amount) {
            this.remaining -= amount;
            if (!this.inverted) {
                this.currPre += amount;
                this.pre = this.currPre;
            } else {
                this.currPost += amount;
                this.post = this.currPost;
                this.inverted = false;
            }
        }
    }
}

