/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura;

import com.mojang.authlib.GameProfile;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3312;
import net.minecraft.class_3695;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import org.figuramc.figura.avatar.Avatar;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.CacheAvatarLoader;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.avatar.local.LocalAvatarLoader;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.compat.GeckoLibCompat;
import org.figuramc.figura.compat.SimpleVCCompat;
import org.figuramc.figura.config.Configs;
import org.figuramc.figura.entries.EntryPointManager;
import org.figuramc.figura.font.Emojis;
import org.figuramc.figura.lua.FiguraLuaPrinter;
import org.figuramc.figura.lua.docs.FiguraDocsManager;
import org.figuramc.figura.mixin.SkullBlockEntityAccessor;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.resources.FiguraRuntimeResources;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraModMetadata;
import org.figuramc.figura.utils.FiguraResourceListener;
import org.figuramc.figura.utils.IOUtils;
import org.figuramc.figura.utils.PlatformUtils;
import org.figuramc.figura.utils.TextUtils;
import org.figuramc.figura.utils.Version;
import org.figuramc.figura.wizards.AvatarWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiguraMod {
    public static final String MOD_ID = "figura";
    public static final String MOD_NAME = "Figura";
    public static final FiguraModMetadata METADATA = FiguraModMetadata.getMetadataForMod("figura");
    public static final Version VERSION = new Version(PlatformUtils.getFiguraModVersionString());
    public static final Calendar CALENDAR = Calendar.getInstance();
    public static final Path GAME_DIR = PlatformUtils.getGameDir().normalize();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Figura");
    public static final float VERTEX_OFFSET = -5.0E-4f;
    public static int ticks;
    public static class_1297 extendedPickEntity;
    public static class_2561 splashText;
    public static boolean parseMessages;
    public static boolean processingKeybind;

    public static boolean debugModeEnabled() {
        return Configs.DEBUG_MODE != null && (Boolean)Configs.DEBUG_MODE.value != false;
    }

    public static void onClientInit() {
        EntryPointManager.init();
        PermissionManager.init();
        LocalAvatarFetcher.init();
        CacheAvatarLoader.init();
        FiguraDocsManager.init();
        FiguraRuntimeResources.init();
        GeckoLibCompat.init();
        SimpleVCCompat.init();
    }

    public static List<FiguraResourceListener> getResourceListeners() {
        ArrayList<FiguraResourceListener> listeners = new ArrayList<FiguraResourceListener>();
        listeners.add(LocalAvatarLoader.AVATAR_LISTENER);
        listeners.add(Emojis.RESOURCE_LISTENER);
        listeners.add(AvatarWizard.RESOURCE_LISTENER);
        listeners.add(AvatarManager.RESOURCE_RELOAD_EVENT);
        return listeners;
    }

    public static void tick() {
        FiguraMod.pushProfiler("network");
        NetworkStuff.tick();
        FiguraMod.popPushProfiler("files");
        LocalAvatarLoader.tick();
        LocalAvatarFetcher.tick();
        FiguraMod.popPushProfiler("avatars");
        AvatarManager.tickLoadedAvatars();
        FiguraMod.popPushProfiler("chatPrint");
        FiguraLuaPrinter.printChatFromQueue();
        FiguraMod.popPushProfiler("emojiAnim");
        Emojis.tickAnimations();
        FiguraMod.popProfiler();
        ++ticks;
    }

    public static void debug(String str, Object ... args) {
        if (FiguraMod.debugModeEnabled()) {
            LOGGER.info("[DEBUG] " + str, args);
        } else {
            LOGGER.debug(str, args);
        }
    }

    public static Path getFiguraDirectory() {
        String config = (String)Configs.MAIN_DIR.value;
        Path p = config.isBlank() ? GAME_DIR.resolve(MOD_ID) : Path.of(config, new String[0]);
        return IOUtils.createDirIfNeeded(p);
    }

    public static Path getCacheDirectory() {
        return IOUtils.getOrCreateDir(FiguraMod.getFiguraDirectory(), (Boolean)Configs.LOCAL_ASSETS.value != false ? "local_cache" : "cache");
    }

    public static UUID getLocalPlayerUUID() {
        class_746 player = class_310.method_1551().field_1724;
        return player != null ? player.method_5667() : class_310.method_1551().method_1548().method_1677().getId();
    }

    public static boolean isLocal(UUID other) {
        return FiguraMod.getLocalPlayerUUID().equals(other);
    }

    public static void sendChatMessage(class_2561 message) {
        if (class_310.method_1551().field_1705 != null) {
            parseMessages = false;
            class_310.method_1551().field_1705.method_1743().method_1812(TextUtils.replaceTabs((class_5348)message));
            parseMessages = true;
        } else {
            LOGGER.info(message.getString());
        }
    }

    public static UUID playerNameToUUID(String playerName) {
        class_3312 cache = SkullBlockEntityAccessor.getProfileCache();
        if (cache == null) {
            return null;
        }
        Optional profile = cache.method_14515(playerName);
        return profile.isEmpty() ? null : ((GameProfile)profile.get()).getId();
    }

    public static class_2583 getAccentColor() {
        Avatar avatar = AvatarManager.getAvatarForPlayer(FiguraMod.getLocalPlayerUUID());
        int color = avatar != null ? ColorUtils.rgbToInt(ColorUtils.userInputHex(avatar.color, ColorUtils.Colors.AWESOME_BLUE.vec)) : ColorUtils.Colors.AWESOME_BLUE.hex;
        return class_2583.field_24360.method_36139(color);
    }

    public static void pushProfiler(String name) {
        class_310.method_1551().method_16011().method_15396(name);
    }

    public static void pushProfiler(Avatar avatar) {
        class_310.method_1551().method_16011().method_15396(avatar.entityName.isBlank() ? avatar.owner.toString() : avatar.entityName);
    }

    public static void popPushProfiler(String name) {
        class_310.method_1551().method_16011().method_15405(name);
    }

    public static void popProfiler() {
        class_310.method_1551().method_16011().method_15407();
    }

    public static <T> T popReturnProfiler(T var) {
        class_310.method_1551().method_16011().method_15407();
        return var;
    }

    public static void popProfiler(int times) {
        class_3695 profiler = class_310.method_1551().method_16011();
        for (int i = 0; i < times; ++i) {
            profiler.method_15407();
        }
    }

    static {
        parseMessages = true;
    }

    public static enum Links {
        Wiki("https://wiki.figuramc.org/", ColorUtils.Colors.AWESOME_BLUE.style),
        Kofi("https://ko-fi.com/skyrina", ColorUtils.Colors.KOFI.style),
        OpenCollective("https://opencollective.com/figura", ColorUtils.Colors.KOFI.style),
        Discord("https://discord.figuramc.org/", ColorUtils.Colors.DISCORD.style),
        Github("https://github.com/FiguraMC/Figura", ColorUtils.Colors.GITHUB.style),
        Modrinth("https://modrinth.com/mod/figura", ColorUtils.Colors.MODRINTH.style),
        Curseforge("https://www.curseforge.com/minecraft/mc-mods/figura", ColorUtils.Colors.CURSEFORGE.style),
        LuaManual("https://www.lua.org/manual/5.2/manual.html", ColorUtils.Colors.LUA_LOG.style);

        public final String url;
        public final class_2583 style;

        private Links(String url, class_2583 style) {
            this.url = url;
            this.style = style;
        }
    }
}

