/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vertices;

import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.QuadView;
import net.coderbot.iris.vertices.TriView;
import org.jetbrains.annotations.NotNull;

public abstract class NormalHelper {
    private NormalHelper() {
    }

    public static int invertPackedNormal(int n) {
        int n2 = -(n & 0xFF);
        int n3 = -(n >> 8 & 0xFF);
        int n4 = -(n >> 16 & 0xFF);
        return n & 0xFF000000 | (n4 &= 0xFF) << 16 | (n3 &= 0xFF) << 8 | (n2 &= 0xFF);
    }

    public static void computeFaceNormal(@NotNull Vector3f vector3f, QuadView quadView) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7 = quadView.x(0);
        float f8 = quadView.y(0);
        float f9 = quadView.z(0);
        float f10 = quadView.x(1);
        float f11 = quadView.y(1);
        float f12 = quadView.z(1);
        float f13 = quadView.x(2);
        float f14 = quadView.y(2);
        float f15 = quadView.z(2);
        float f16 = quadView.x(3);
        float f17 = quadView.y(3);
        float f18 = f14 - f8;
        float f19 = quadView.z(3);
        float f20 = f19 - f12;
        float f21 = f18 * f20 - (f6 = f15 - f9) * (f5 = f17 - f11);
        float f22 = (float)Math.sqrt(f21 * f21 + (f4 = f6 * (f3 = f16 - f10) - (f2 = f13 - f7) * f20) * f4 + (f = f2 * f5 - f18 * f3) * f);
        if (f22 != 0.0f) {
            f21 /= f22;
            f4 /= f22;
            f /= f22;
        }
        vector3f.set(f21, f4, f);
    }

    public static void computeFaceNormalTri(@NotNull Vector3f vector3f, TriView triView) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = triView.x(0);
        float f10 = triView.y(0);
        float f11 = triView.z(0);
        float f12 = triView.x(1);
        float f13 = triView.y(1);
        float f14 = triView.z(1);
        float f15 = triView.x(2);
        float f16 = triView.y(2);
        float f17 = f16 - f10;
        float f18 = f17 * (f8 = f11 - f14) - (f7 = (f6 = triView.z(2)) - f11) * (f5 = f10 - f13);
        float f19 = (float)Math.sqrt(f18 * f18 + (f4 = f7 * (f3 = f9 - f12) - (f2 = f15 - f9) * f8) * f4 + (f = f2 * f5 - f17 * f3) * f);
        if (f19 != 0.0f) {
            f18 /= f19;
            f4 /= f19;
            f /= f19;
        }
        vector3f.set(f18, f4, f);
    }

    public static int computeTangentSmooth(float f, float f2, float f3, TriView triView) {
        float f4;
        float f5;
        float f6 = triView.x(0);
        float f7 = triView.y(0);
        float f8 = triView.z(0);
        float f9 = triView.x(1);
        float f10 = triView.y(1);
        float f11 = triView.z(1);
        float f12 = triView.x(2);
        float f13 = triView.y(2);
        float f14 = triView.z(2);
        float f15 = f6 * f + f7 * f2 + f8 * f3;
        float f16 = f9 * f + f10 * f2 + f11 * f3;
        float f17 = f12 * f + f13 * f2 + f14 * f3;
        f6 -= f15 * f;
        f7 -= f15 * f2;
        f8 -= f15 * f3;
        f9 -= f16 * f;
        f10 -= f16 * f2;
        f11 -= f16 * f3;
        f12 -= f17 * f;
        f13 -= f17 * f2;
        f14 -= f17 * f3;
        float f18 = f9 - f6;
        float f19 = f10 - f7;
        float f20 = f11 - f8;
        float f21 = f12 - f6;
        float f22 = f13 - f7;
        float f23 = f14 - f8;
        float f24 = triView.u(0);
        float f25 = triView.v(0);
        float f26 = triView.u(1);
        float f27 = triView.v(1);
        float f28 = triView.u(2);
        float f29 = f26 - f24;
        float f30 = triView.v(2);
        float f31 = f30 - f25;
        float f32 = f29 * f31 - (f5 = f28 - f24) * (f4 = f27 - f25);
        float f33 = (double)f32 == 0.0 ? 1.0f : 1.0f / f32;
        float f34 = f33 * (f31 * f18 - f4 * f21);
        float f35 = f33 * (f31 * f19 - f4 * f22);
        float f36 = f33 * (f31 * f20 - f4 * f23);
        float f37 = NormalHelper.rsqrt(f34 * f34 + f35 * f35 + f36 * f36);
        f34 *= f37;
        f35 *= f37;
        float f38 = f33 * (-f5 * f18 + f29 * f21);
        float f39 = f33 * (-f5 * f19 + f29 * f22);
        float f40 = f33 * (-f5 * f20 + f29 * f23);
        float f41 = NormalHelper.rsqrt(f38 * f38 + f39 * f39 + f40 * f40);
        float f42 = f35 * f3 - (f36 *= f37) * f2;
        float f43 = f36 * f - f34 * f3;
        float f44 = f34 * f2 - f35 * f;
        float f45 = (f38 *= f41) * f42 + (f39 *= f41) * f43 + (f40 *= f41) * f44;
        float f46 = f45 < 0.0f ? -1.0f : 1.0f;
        return NormI8.pack(f34, f35, f36, f46);
    }

    public static int computeTangent(float f, float f2, float f3, TriView triView) {
        float f4;
        float f5;
        float f6 = triView.x(0);
        float f7 = triView.y(0);
        float f8 = triView.z(0);
        float f9 = triView.x(1);
        float f10 = triView.y(1);
        float f11 = triView.z(1);
        float f12 = triView.x(2);
        float f13 = triView.y(2);
        float f14 = triView.z(2);
        float f15 = f9 - f6;
        float f16 = f10 - f7;
        float f17 = f11 - f8;
        float f18 = f12 - f6;
        float f19 = f13 - f7;
        float f20 = f14 - f8;
        float f21 = triView.u(0);
        float f22 = triView.v(0);
        float f23 = triView.u(1);
        float f24 = triView.v(1);
        float f25 = triView.u(2);
        float f26 = f23 - f21;
        float f27 = triView.v(2);
        float f28 = f27 - f22;
        float f29 = f26 * f28 - (f5 = f25 - f21) * (f4 = f24 - f22);
        float f30 = (double)f29 == 0.0 ? 1.0f : 1.0f / f29;
        float f31 = f30 * (f28 * f15 - f4 * f18);
        float f32 = f30 * (f28 * f16 - f4 * f19);
        float f33 = f30 * (f28 * f17 - f4 * f20);
        float f34 = NormalHelper.rsqrt(f31 * f31 + f32 * f32 + f33 * f33);
        f31 *= f34;
        f32 *= f34;
        float f35 = f30 * (-f5 * f15 + f26 * f18);
        float f36 = f30 * (-f5 * f16 + f26 * f19);
        float f37 = f30 * (-f5 * f17 + f26 * f20);
        float f38 = NormalHelper.rsqrt(f35 * f35 + f36 * f36 + f37 * f37);
        float f39 = f32 * f3 - (f33 *= f34) * f2;
        float f40 = f33 * f - f31 * f3;
        float f41 = f31 * f2 - f32 * f;
        float f42 = (f35 *= f38) * f39 + (f36 *= f38) * f40 + (f37 *= f38) * f41;
        float f43 = f42 < 0.0f ? -1.0f : 1.0f;
        return NormI8.pack(f31, f32, f33, f43);
    }

    private static float rsqrt(float f) {
        if (f == 0.0f) {
            return 1.0f;
        }
        return (float)(1.0 / Math.sqrt(f));
    }
}

