/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.Objects;
import java.util.stream.StreamSupport;
import net.coderbot.iris.JomlConversions;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.coderbot.iris.mixin.DimensionTypeAccessor;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector4f;
import net.minecraft.class_1538;
import net.minecraft.class_1934;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class IrisExclusiveUniforms {
    public static void addIrisExclusiveUniforms(UniformHolder uniformHolder) {
        WorldInfoUniforms.addWorldInfoUniforms(uniformHolder);
        uniformHolder.uniform1i(UniformUpdateFrequency.PER_TICK, "currentColorSpace", () -> IrisVideoSettings.colorSpace.ordinal());
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "thunderStrength", IrisExclusiveUniforms::getThunderStrength);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHealth", IrisExclusiveUniforms::getCurrentHealth);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHealth", IrisExclusiveUniforms::getMaxHealth);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerHunger", IrisExclusiveUniforms::getCurrentHunger);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerHunger", () -> 20);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "currentPlayerAir", IrisExclusiveUniforms::getCurrentAir);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_TICK, "maxPlayerAir", IrisExclusiveUniforms::getMaxAir);
        uniformHolder.uniform1b(UniformUpdateFrequency.PER_FRAME, "firstPersonCamera", IrisExclusiveUniforms::isFirstPersonCamera);
        uniformHolder.uniform1b(UniformUpdateFrequency.PER_TICK, "isSpectator", IrisExclusiveUniforms::isSpectator);
        uniformHolder.uniform3d(UniformUpdateFrequency.PER_FRAME, "eyePosition", IrisExclusiveUniforms::getEyePosition);
        uniformHolder.uniform3d(UniformUpdateFrequency.PER_FRAME, "relativeEyePosition", () -> CameraUniforms.getUnshiftedCameraPosition().sub(IrisExclusiveUniforms.getEyePosition()));
        uniformHolder.uniform3d(UniformUpdateFrequency.PER_FRAME, "playerLookVector", () -> JomlConversions.fromVec3(class_310.method_1551().method_1560().method_5720()));
        uniformHolder.uniform3d(UniformUpdateFrequency.PER_FRAME, "playerBodyVector", () -> JomlConversions.fromVec3(class_310.method_1551().method_1560().method_5663()));
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        uniformHolder.uniform4f(UniformUpdateFrequency.PER_TICK, "lightningBoltPosition", () -> {
            if (class_310.method_1551().field_1687 != null) {
                return StreamSupport.stream(class_310.method_1551().field_1687.method_18112().spliterator(), false).filter(class_12972 -> class_12972 instanceof class_1538).findAny().map(class_12972 -> {
                    Vector3d vector3d = CameraUniforms.getUnshiftedCameraPosition();
                    class_243 class_2432 = class_12972.method_30950(class_310.method_1551().method_1534());
                    return new Vector4f((float)(class_2432.field_1352 - vector3d.x), (float)(class_2432.field_1351 - vector3d.y), (float)(class_2432.field_1350 - vector3d.z), 1.0f);
                }).orElse(vector4f);
            }
            return vector4f;
        });
    }

    private static float getThunderStrength() {
        return Math.clamp(0.0f, 1.0f, class_310.method_1551().field_1687.method_8478(CapturedRenderingState.INSTANCE.getTickDelta()));
    }

    private static float getCurrentHealth() {
        if (class_310.method_1551().field_1724 == null || !class_310.method_1551().field_1761.method_2920().method_8388()) {
            return -1.0f;
        }
        return class_310.method_1551().field_1724.method_6032() / class_310.method_1551().field_1724.method_6063();
    }

    private static float getCurrentHunger() {
        if (class_310.method_1551().field_1724 == null || !class_310.method_1551().field_1761.method_2920().method_8388()) {
            return -1.0f;
        }
        return (float)class_310.method_1551().field_1724.method_7344().method_7586() / 20.0f;
    }

    private static float getCurrentAir() {
        if (class_310.method_1551().field_1724 == null || !class_310.method_1551().field_1761.method_2920().method_8388()) {
            return -1.0f;
        }
        return (float)class_310.method_1551().field_1724.method_5669() / (float)class_310.method_1551().field_1724.method_5748();
    }

    private static float getMaxAir() {
        if (class_310.method_1551().field_1724 == null || !class_310.method_1551().field_1761.method_2920().method_8388()) {
            return -1.0f;
        }
        return class_310.method_1551().field_1724.method_5748();
    }

    private static float getMaxHealth() {
        if (class_310.method_1551().field_1724 == null || !class_310.method_1551().field_1761.method_2920().method_8388()) {
            return -1.0f;
        }
        return class_310.method_1551().field_1724.method_6063();
    }

    private static boolean isFirstPersonCamera() {
        switch (class_310.method_1551().field_1690.method_31044()) {
            case field_26665: 
            case field_26666: {
                return false;
            }
        }
        return true;
    }

    private static boolean isSpectator() {
        return class_310.method_1551().field_1761.method_2920() == class_1934.field_9219;
    }

    private static Vector3d getEyePosition() {
        Objects.requireNonNull(class_310.method_1551().method_1560());
        class_243 class_2432 = class_310.method_1551().method_1560().method_5836(CapturedRenderingState.INSTANCE.getTickDelta());
        return new Vector3d(class_2432.field_1352, class_2432.field_1351, class_2432.field_1350);
    }

    public static class WorldInfoUniforms {
        public static void addWorldInfoUniforms(UniformHolder uniformHolder) {
            class_638 class_6382 = class_310.method_1551().field_1687;
            uniformHolder.uniform1i(UniformUpdateFrequency.PER_FRAME, "bedrockLevel", () -> {
                if (class_6382 != null) {
                    return class_6382.method_8597().method_29959();
                }
                return 0;
            });
            uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "cloudHeight", () -> {
                if (class_6382 != null) {
                    return class_6382.method_28103().method_28108();
                }
                return 192.0;
            });
            uniformHolder.uniform1i(UniformUpdateFrequency.PER_FRAME, "heightLimit", () -> {
                if (class_6382 != null) {
                    return class_6382.method_8597().method_32924();
                }
                return 256;
            });
            uniformHolder.uniform1i(UniformUpdateFrequency.PER_FRAME, "logicalHeightLimit", () -> {
                if (class_6382 != null) {
                    return class_6382.method_8597().method_32925();
                }
                return 256;
            });
            uniformHolder.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasCeiling", () -> {
                if (class_6382 != null) {
                    return class_6382.method_8597().method_27998();
                }
                return false;
            });
            uniformHolder.uniform1b(UniformUpdateFrequency.PER_FRAME, "hasSkylight", () -> {
                if (class_6382 != null) {
                    return class_6382.method_8597().method_12491();
                }
                return true;
            });
            uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "ambientLight", () -> {
                if (class_6382 != null) {
                    return ((DimensionTypeAccessor)class_6382.method_8597()).getAmbientLight();
                }
                return 0.0f;
            });
        }
    }
}

