/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline.transform.transformer;

import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.ASTParser;
import net.coderbot.iris.gl.shader.ShaderType;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.parameter.VanillaParameters;
import net.coderbot.iris.pipeline.transform.transformer.AttributeTransformer;
import net.coderbot.iris.pipeline.transform.transformer.CommonTransformer;

public class VanillaTransformer {
    public static void transform(ASTParser aSTParser, TranslationUnit translationUnit, Root root, VanillaParameters vanillaParameters) {
        if (vanillaParameters.inputs.hasOverlay()) {
            if (!vanillaParameters.inputs.isText()) {
                AttributeTransformer.patchOverlayColor(aSTParser, translationUnit, root, vanillaParameters);
            }
            AttributeTransformer.patchEntityId(aSTParser, translationUnit, root, vanillaParameters);
        }
        CommonTransformer.transform(aSTParser, translationUnit, root, vanillaParameters, false);
        if (vanillaParameters.type.glShaderType == ShaderType.VERTEX) {
            root.rename("gl_MultiTexCoord2", "gl_MultiTexCoord1");
            if (vanillaParameters.inputs.hasTex()) {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(iris_UV0, 0.0, 1.0)");
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec2 iris_UV0;");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord0", "vec4(0.5, 0.5, 0.0, 1.0)");
            }
            if (vanillaParameters.inputs.hasLight()) {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(iris_UV2, 0.0, 1.0)");
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in ivec2 iris_UV2;");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_MultiTexCoord1", "vec4(240.0, 240.0, 0.0, 1.0)");
            }
            AttributeTransformer.patchMultiTexCoord3(aSTParser, translationUnit, root, vanillaParameters);
            CommonTransformer.replaceGlMultiTexCoordBounded(aSTParser, root, 4, 7);
        }
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform vec4 iris_ColorModulator;");
        if (vanillaParameters.inputs.hasColor() && vanillaParameters.type == PatchShaderType.VERTEX) {
            if (vanillaParameters.alpha == AlphaTests.VERTEX_ALPHA) {
                root.replaceReferenceExpressions(aSTParser, "gl_Color", "vec4((iris_Color * iris_ColorModulator).rgb, iris_ColorModulator.a)");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_Color", "(iris_Color * iris_ColorModulator)");
            }
            if (vanillaParameters.type.glShaderType == ShaderType.VERTEX) {
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec4 iris_Color;");
            }
        } else {
            root.rename("gl_Color", "iris_ColorModulator");
        }
        if (vanillaParameters.type.glShaderType == ShaderType.VERTEX) {
            if (vanillaParameters.inputs.hasNormal()) {
                if (!vanillaParameters.inputs.isNewLines()) {
                    root.rename("gl_Normal", "iris_Normal");
                } else {
                    root.replaceReferenceExpressions(aSTParser, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
                }
                translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "in vec3 iris_Normal;");
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_Normal", "vec3(0.0, 0.0, 1.0)");
            }
        }
        translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"uniform mat4 iris_LightmapTextureMatrix;", "uniform mat4 iris_TextureMat;", "uniform mat4 iris_ModelViewMat;"});
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix0, "iris_TextureMat");
        root.replaceExpressionMatches(aSTParser, CommonTransformer.glTextureMatrix1, "iris_LightmapTextureMatrix");
        root.replaceReferenceExpressions(aSTParser, "gl_NormalMatrix", "iris_NormalMat");
        root.replaceReferenceExpressions(aSTParser, "gl_ModelViewMatrixInverse", "iris_ModelViewMatInverse");
        root.replaceReferenceExpressions(aSTParser, "gl_ProjectionMatrixInverse", "iris_ProjMatInverse");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat3 iris_NormalMat;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjMatInverse;");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ModelViewMatInverse;");
        if (vanillaParameters.type.glShaderType == ShaderType.VERTEX) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"in vec3 iris_Position;"});
            if (root.identifierIndex.has("ftransform")) {
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"vec4 ftransform() { return gl_ModelViewProjectionMatrix * gl_Vertex; }"});
            }
            if (vanillaParameters.inputs.isNewLines()) {
                root.replaceReferenceExpressions(aSTParser, "gl_Vertex", "vec4(iris_Position + iris_vertex_offset, 1.0)");
                root.rename("main", "irisMain");
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"vec3 iris_vertex_offset = vec3(0.0);"});
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.END, new String[]{"uniform vec2 iris_ScreenSize;", "uniform float iris_LineWidth;", "void iris_widen_lines(vec4 linePosStart, vec4 linePosEnd) {vec3 ndc1 = linePosStart.xyz / linePosStart.w;vec3 ndc2 = linePosEnd.xyz / linePosEnd.w;vec2 lineScreenDirection = normalize((ndc2.xy - ndc1.xy) * iris_ScreenSize);vec2 lineOffset = vec2(-lineScreenDirection.y, lineScreenDirection.x) * iris_LineWidth / iris_ScreenSize;if (lineOffset.x < 0.0) {    lineOffset *= -1.0;}if (gl_VertexID % 2 == 0) {    gl_Position = vec4((ndc1 + vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);} else {    gl_Position = vec4((ndc1 - vec3(lineOffset, 0.0)) * linePosStart.w, linePosStart.w);}}", "void main() {iris_vertex_offset = iris_Normal;irisMain();vec4 linePosEnd = gl_Position;gl_Position = vec4(0.0);iris_vertex_offset = vec3(0.0);irisMain();vec4 linePosStart = gl_Position;iris_widen_lines(linePosStart, linePosEnd);}"});
            } else {
                root.replaceReferenceExpressions(aSTParser, "gl_Vertex", "vec4(iris_Position, 1.0)");
            }
        }
        root.replaceReferenceExpressions(aSTParser, "gl_ModelViewProjectionMatrix", "(gl_ProjectionMatrix * gl_ModelViewMatrix)");
        if (vanillaParameters.hasChunkOffset) {
            boolean bl = root.replaceReferenceExpressionsReport(aSTParser, "gl_ModelViewMatrix", "(iris_ModelViewMat * _iris_internal_translate(iris_ChunkOffset))");
            if (bl) {
                translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_FUNCTIONS, new String[]{"uniform vec3 iris_ChunkOffset;", "mat4 _iris_internal_translate(vec3 offset) {return mat4(1.0, 0.0, 0.0, 0.0,0.0, 1.0, 0.0, 0.0,0.0, 0.0, 1.0, 0.0,offset.x, offset.y, offset.z, 1.0); }"});
            }
        } else if (vanillaParameters.inputs.isNewLines()) {
            translationUnit.parseAndInjectNodes(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, new String[]{"const float iris_VIEW_SHRINK = 1.0 - (1.0 / 256.0);", "const mat4 iris_VIEW_SCALE = mat4(iris_VIEW_SHRINK, 0.0, 0.0, 0.0,0.0, iris_VIEW_SHRINK, 0.0, 0.0,0.0, 0.0, iris_VIEW_SHRINK, 0.0,0.0, 0.0, 0.0, 1.0);"});
            root.replaceReferenceExpressions(aSTParser, "gl_ModelViewMatrix", "(iris_VIEW_SCALE * iris_ModelViewMat)");
        } else {
            root.rename("gl_ModelViewMatrix", "iris_ModelViewMat");
        }
        root.rename("gl_ProjectionMatrix", "iris_ProjMat");
        translationUnit.parseAndInjectNode(aSTParser, ASTInjectionPoint.BEFORE_DECLARATIONS, "uniform mat4 iris_ProjMat;");
    }
}

