/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import java.nio.ByteBuffer;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterNio;
import me.jellysquid.mods.sodium.client.model.vertex.type.BufferVertexType;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import net.coderbot.iris.compat.sodium.impl.block_context.BlockContextHolder;
import net.coderbot.iris.compat.sodium.impl.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.compat.sodium.impl.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPModelVertexType;
import net.coderbot.iris.vendored.joml.Vector3f;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;

public class XHFPModelVertexBufferWriterNio
extends VertexBufferWriterNio
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainNio quad = new QuadViewTerrain.QuadViewTerrainNio();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterNio(VertexBufferView vertexBufferView) {
        super(vertexBufferView, (BufferVertexType)IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void copyQuadAndFlipNormal() {
        this.ensureCapacity(4);
        ByteBuffer byteBuffer = this.byteBuffer.duplicate();
        ByteBuffer byteBuffer2 = this.byteBuffer.duplicate();
        byteBuffer.position(this.byteBuffer.position() + this.writeOffset - 160);
        byteBuffer.limit(byteBuffer.position() + 160);
        byteBuffer2.position(this.byteBuffer.position() + this.writeOffset);
        byteBuffer2.limit(byteBuffer2.position() + 160);
        byteBuffer2.put(byteBuffer);
        int n = this.byteBuffer.getInt(this.writeOffset + 28);
        int n2 = NormalHelper.invertPackedNormal(n);
        this.byteBuffer.putInt(this.writeOffset + 28, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 40, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 80, n2);
        this.byteBuffer.putInt(this.writeOffset + 28 + 120, n2);
        for (int i = 0; i < 4; ++i) {
            this.advance();
        }
        this.flush();
    }

    public void writeVertex(float f, float f2, float f3, int n, float f4, float f5, int n2, int n3) {
        this.uSum += f4;
        this.vSum += f5;
        short s = this.contextHolder.blockId;
        short s2 = this.contextHolder.renderType;
        this.writeQuadInternal(f, f2, f3, n, f4, f5, n2, s, s2, n3, ExtendedDataHelper.computeMidBlock(f, f2, f3, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(float f, float f2, float f3, int n, float f4, float f5, int n2, short s, short s2, int n3, int n4) {
        int n5 = this.writeOffset;
        ++this.vertexCount;
        ByteBuffer byteBuffer = this.byteBuffer;
        byteBuffer.putShort(n5 + 0, XHFPModelVertexType.encodePosition(f));
        byteBuffer.putShort(n5 + 2, XHFPModelVertexType.encodePosition(f2));
        byteBuffer.putShort(n5 + 4, XHFPModelVertexType.encodePosition(f3));
        byteBuffer.putShort(n5 + 6, (short)n3);
        byteBuffer.putInt(n5 + 8, n);
        byteBuffer.putShort(n5 + 12, XHFPModelVertexType.encodeBlockTexture(f4));
        byteBuffer.putShort(n5 + 14, XHFPModelVertexType.encodeBlockTexture(f5));
        byteBuffer.putShort(n5 + 16, (short)(n2 & 0xFFFF));
        byteBuffer.putShort(n5 + 18, (short)(n2 >> 16 & 0xFFFF));
        byteBuffer.putShort(n5 + 32, s);
        byteBuffer.putShort(n5 + 34, s2);
        byteBuffer.putInt(n5 + 36, n4);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            short s3 = XHFPModelVertexType.encodeBlockTexture(this.uSum);
            short s4 = XHFPModelVertexType.encodeBlockTexture(this.vSum);
            byteBuffer.putShort(n5 + 20, s3);
            byteBuffer.putShort(n5 + 20 - 40, s3);
            byteBuffer.putShort(n5 + 20 - 80, s3);
            byteBuffer.putShort(n5 + 20 - 120, s3);
            byteBuffer.putShort(n5 + 22, s4);
            byteBuffer.putShort(n5 + 22 - 40, s4);
            byteBuffer.putShort(n5 + 22 - 80, s4);
            byteBuffer.putShort(n5 + 22 - 120, s4);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(byteBuffer, n5, 40);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int n6 = NormI8.pack(this.normal.x, this.normal.y, this.normal.z, 0.0f);
            byteBuffer.putInt(n5 + 28, n6);
            byteBuffer.putInt(n5 + 28 - 40, n6);
            byteBuffer.putInt(n5 + 28 - 80, n6);
            byteBuffer.putInt(n5 + 28 - 120, n6);
            int n7 = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            byteBuffer.putInt(n5 + 24, n7);
            byteBuffer.putInt(n5 + 24 - 40, n7);
            byteBuffer.putInt(n5 + 24 - 80, n7);
            byteBuffer.putInt(n5 + 24 - 120, n7);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder blockContextHolder) {
        this.contextHolder = blockContextHolder;
    }
}

