/*
 * Decompiled with CFR 0.152.
 */
package com.nebspacefarer.stendhal.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class StendhalSign {
    @Nullable
    public static Sign importSign = null;

    public static void exportSign(class_2561 title, List<String> lines) {
        String fileName = title.getString().replace(" ", "_").toLowerCase();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs/" + fileName + ".stendhal"), StandardCharsets.UTF_8));){
            String signString = "title: " + title.getString() + "\nlines:\n";
            for (String line : lines) {
                signString = signString + "#- " + line + "\n";
            }
            out.write(signString);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Sign importSign(String fileName) {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs/" + fileName + ".stendhal"), decoder));
            Sign importedSign = new Sign(class_2561.method_30163((String)""), new ArrayList<class_2561>());
            ArrayList<class_2561> importedLines = new ArrayList<class_2561>();
            Object currentPage = "";
            Boolean pageMode = false;
            @Nullable String line = br.readLine();
            while (line != null) {
                if (line.startsWith("title:")) {
                    importedSign.setSignTitle(class_2561.method_30163((String)line.replace("title: ", "")));
                }
                if (pageMode.booleanValue() && !line.startsWith("#- ")) {
                    currentPage = (String)currentPage + line + "\n";
                }
                if (line.startsWith("#- ")) {
                    pageMode = true;
                    if (currentPage != "") {
                        importedLines.add(class_2561.method_30163((String)currentPage));
                    }
                    currentPage = line.replace("#- ", "") + "\n";
                }
                line = br.readLine();
            }
            importedLines.add(class_2561.method_30163((String)currentPage));
            br.close();
            importedSign.setSignText(importedLines);
            return importedSign;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean doesSignExists(String fileName) {
        if (new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs/" + fileName + ".stendhal").exists()) {
            return true;
        }
        return false;
    }

    public static List<Sign> getSigns() {
        String[] contents = new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs/").list();
        if (contents != null) {
            ArrayList<Sign> signLists = new ArrayList<Sign>();
            for (int i = 0; i < contents.length; ++i) {
                String thisSignFileName = contents[i].replace(".stendhal", "");
                Sign thisSign = StendhalSign.importSign(thisSignFileName);
                if (thisSign == null) continue;
                signLists.add(thisSign);
            }
            return signLists;
        }
        return new ArrayList<Sign>();
    }

    public static class Sign {
        private class_2561 signTitle;
        private ArrayList<class_2561> signText;

        public Sign(class_2561 signTitle, ArrayList<class_2561> signText) {
            this.signTitle = signTitle;
            this.signText = signText;
        }

        public class_2561 getSignTitle() {
            return this.signTitle;
        }

        public void setSignTitle(class_2561 signTitle) {
            this.signTitle = signTitle;
        }

        public ArrayList<class_2561> getSignText() {
            return this.signText;
        }

        public void setSignText(ArrayList<class_2561> signText) {
            this.signText = signText;
        }
    }
}

