/*
 * Decompiled with CFR 0.152.
 */
package com.nebspacefarer.stendhal.screens;

import com.nebspacefarer.stendhal.screens.ImportSignScreen;
import com.nebspacefarer.stendhal.utils.StendhalClipboard;
import com.nebspacefarer.stendhal.utils.StendhalSign;
import io.github.cottonmc.cotton.gui.GuiDescription;
import io.github.cottonmc.cotton.gui.client.LightweightGuiDescription;
import io.github.cottonmc.cotton.gui.widget.WButton;
import io.github.cottonmc.cotton.gui.widget.WLabel;
import io.github.cottonmc.cotton.gui.widget.WListPanel;
import io.github.cottonmc.cotton.gui.widget.WPanel;
import io.github.cottonmc.cotton.gui.widget.WPlainPanel;
import io.github.cottonmc.cotton.gui.widget.WTextField;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.icon.Icon;
import io.github.cottonmc.cotton.gui.widget.icon.ItemIcon;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ImportSignGUI
extends LightweightGuiDescription {
    ArrayList<String> data = new ArrayList();
    List<StendhalSign.Sign> allSigns = StendhalSign.getSigns();
    WListPanel<String, StendhalSignListPanel> list = null;
    String searchTerms = null;

    public ImportSignGUI() {
        class_310 client = class_310.method_1551();
        WPlainPanel root = new WPlainPanel();
        this.setRootPanel((WPanel)root);
        root.setSize(300, 200);
        if (new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs").mkdirs()) {
            System.out.println("[Stendhal] Signs folder created.");
        }
        WLabel labelScreen = new WLabel(class_2561.method_30163((String)("\u00a7l" + new class_2588("stendhal.signLoad").getString())).getString()).setHorizontalAlignment(HorizontalAlignment.CENTER);
        root.add((WWidget)labelScreen, 10, 10, root.getWidth() - 20, 20);
        WLabel labelSignDir = new WLabel(class_2561.method_30163((String)(new class_2588("stendhal.signDir").getString() + " /.config/stendhal/signs/")).getString(), 0x7D7D7D);
        root.add((WWidget)labelSignDir, 10, 34, root.getWidth() - 20, 20);
        WButton buttonCancel = new WButton((class_2561)new class_2585("x"));
        buttonCancel.setOnClick(() -> client.method_1507(StendhalClipboard.previousScreen));
        root.add((WWidget)buttonCancel, root.getWidth() - 30, 5, 20, 20);
        ArrayList<String> data = new ArrayList<String>();
        List<StendhalSign.Sign> allSigns = StendhalSign.getSigns();
        for (StendhalSign.Sign sign2 : allSigns) {
            data.add(sign2.getSignTitle().getString());
        }
        BiConsumer<String, StendhalSignListPanel> configurator = (s, sign) -> {
            sign.buttonLoad.setLabel(class_2561.method_30163((String)s));
            sign.buttonLoad.setIcon((Icon)new ItemIcon(new class_1799((class_1935)class_1802.field_8788)));
            sign.buttonLoad.setOnClick(() -> {
                for (StendhalSign.Sign thisSign : allSigns) {
                    if (!thisSign.getSignTitle().getString().equals(s)) continue;
                    StendhalSign.importSign = thisSign;
                    client.method_1507(StendhalClipboard.previousScreen);
                }
            });
            sign.buttonDelete.setLabel((class_2561)new class_2588("stendhal.delete"));
            sign.buttonDelete.setOnClick(() -> {
                String signFile = s.replace(" ", "_").toLowerCase();
                new File(FabricLoader.getInstance().getConfigDir() + "/stendhal/signs/" + signFile + ".stendhal").delete();
                client.method_1507(StendhalClipboard.previousScreen);
                client.method_1507((class_437)new ImportSignScreen((GuiDescription)new ImportSignGUI()));
                System.out.println("Sign " + signFile + ".stendhal deleted");
            });
        };
        WTextField searchField = new WTextField();
        root.add((WWidget)searchField, 10, 50, root.getWidth() - 175, 20);
        WButton buttonSearch = new WButton((class_2561)new class_2588("stendhal.searchTerms"));
        buttonSearch.setOnClick(() -> {
            root.remove(this.list);
            this.searchTerms = searchField.getText();
            this.createList(root, data, configurator);
            root.validate((GuiDescription)this);
        });
        root.add((WWidget)buttonSearch, root.getWidth() - 160, 50, 120, 20);
        WButton buttonSort = new WButton((class_2561)new class_2585("\u231a"));
        buttonSort.setOnClick(() -> {});
        buttonSort.setEnabled(false);
        root.add((WWidget)buttonSort, root.getWidth() - 30, 50, 20, 20);
        WListPanel list = new WListPanel(data, StendhalSignListPanel::new, configurator);
        list.setListItemHeight(20);
        root.add((WWidget)list, 0, 75, root.getWidth() - 10, 120);
        root.validate((GuiDescription)this);
    }

    private void createList(WPlainPanel root, ArrayList<String> data, BiConsumer<String, StendhalSignListPanel> configurator) {
        data.clear();
        for (StendhalSign.Sign sign : this.allSigns) {
            if (this.searchTerms != null && sign.getSignTitle().getString().toLowerCase().contains(this.searchTerms.toLowerCase())) {
                data.add(sign.getSignTitle().getString());
                continue;
            }
            if (this.searchTerms != null) continue;
            data.add(sign.getSignTitle().getString());
        }
        this.list = new WListPanel(data, StendhalSignListPanel::new, configurator);
        this.list.setListItemHeight(20);
        root.add(this.list, 0, 75, root.getWidth() - 10, 120);
        this.searchTerms = null;
    }

    public static class StendhalSignListPanel
    extends WPlainPanel {
        WButton buttonLoad = new WButton();
        WButton buttonDelete;

        public StendhalSignListPanel() {
            this.add((WWidget)this.buttonLoad, 10, 0, 180, 20);
            this.buttonDelete = new WButton((class_2561)new class_2588("stendhal.delete"));
            this.add((WWidget)this.buttonDelete, 200, 0, 75, 20);
            this.setSize(300, 20);
        }
    }
}

