/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.util;

import java.util.HashMap;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.models.CemModelRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class CemRegistryManager {
    private static final HashMap<class_1299<? extends class_1297>, JemFile> EntityTypeRegistries = new HashMap();
    private static final HashMap<class_2591<? extends class_2586>, JemFile> BlockEntityTypeRegistries = new HashMap();
    private static final HashMap<String, JemFile> OtherRegistries = new HashMap();

    public static void addRegistry(class_1299<? extends class_1297> entityType, JemFile file) {
        if (file != null) {
            EntityTypeRegistries.put(entityType, file);
        }
    }

    public static void addRegistry(class_2591<? extends class_2586> entityType, JemFile file) {
        if (file != null) {
            BlockEntityTypeRegistries.put(entityType, file);
        }
    }

    public static void addRegistry(String entityType, JemFile file) {
        if (file != null) {
            OtherRegistries.put(entityType, file);
        }
    }

    public static boolean hasEntity(class_1299<? extends class_1297> entityType) {
        return EntityTypeRegistries.containsKey(entityType);
    }

    public static boolean hasEntity(class_2591<? extends class_2586> entityType) {
        return BlockEntityTypeRegistries.containsKey(entityType);
    }

    public static boolean hasEntity(String entityType) {
        return OtherRegistries.containsKey(entityType);
    }

    public static CemModelRegistry getRegistry(class_1299<? extends class_1297> entityType) {
        return new CemModelRegistry(EntityTypeRegistries.get(entityType));
    }

    public static CemModelRegistry getArmorRegistry(class_1299<? extends class_1297> entityType) {
        return new CemModelRegistry(EntityTypeRegistries.get(entityType).getArmorVarient());
    }

    public static CemModelRegistry getRegistry(class_2591<? extends class_2586> entityType) {
        return new CemModelRegistry(BlockEntityTypeRegistries.get(entityType));
    }

    public static CemModelRegistry getRegistry(String entityType) {
        return new CemModelRegistry(OtherRegistries.get(entityType));
    }

    public static void clearRegistries() {
        EntityTypeRegistries.clear();
        BlockEntityTypeRegistries.clear();
        OtherRegistries.clear();
    }
}

