/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.models;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.dorianpb.cem.internal.config.CemConfigFairy;
import net.dorianpb.cem.internal.file.JemFile;
import net.dorianpb.cem.internal.file.JpmFile;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;

public class CemModelEntry {
    private final String id;
    private final String part;
    private final HashMap<ArrayList<String>, CemModelEntry> children;
    private final CemModelPart model;
    private final float[] translates;
    private final float[] rotates;
    private final boolean[] invertAxis;
    private final int gen;
    private final float[] offsets;

    CemModelEntry(JemFile.JemModel file, int textureWidth, int textureHeight) {
        this(file.getPart(), file.getModelDef(), new float[]{0.0f, 24.0f, 0.0f}, 0, file.getScale().floatValue(), textureWidth, textureHeight);
        if (file.getAnimations().size() > 0) {
            for (String key : file.getAnimations().keySet()) {
                if (key.contains(".")) continue;
                throw new InvalidParameterException("Invalid Syntax: " + key);
            }
        }
    }

    private CemModelEntry(String part, JpmFile data, float[] parents, int gen, float scale, int textureWidth, int textureHeight) {
        this.id = data.getId();
        this.part = part;
        this.children = new HashMap();
        this.invertAxis = data.getInvertAxis();
        this.gen = gen;
        this.translates = new float[]{data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1), data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1), data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1)};
        this.rotates = new float[]{data.getRotate().get(0).floatValue() * (float)(this.invertAxis[0] ? 1 : -1), data.getRotate().get(1).floatValue() * (float)(this.invertAxis[1] ? 1 : -1), data.getRotate().get(2).floatValue() * (float)(this.invertAxis[2] ? 1 : -1)};
        this.model = new CemModelPart(textureWidth, textureHeight);
        this.initmodel(data, parents, scale);
        this.offsets = new float[]{0.0f, 0.0f, 0.0f};
        if (data.getSubmodels() != null) {
            for (JpmFile submodel : data.getSubmodels()) {
                float childY;
                float childZ;
                float f = this.gen == 0 ? data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : (childZ = 0.0f);
                float f2 = this.gen == 0 ? data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (childY = 0.0f);
                float childX = this.gen == 0 ? data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : 0.0f;
                this.addChild(new CemModelEntry(null, submodel, new float[]{childX, childY, childZ}, this.gen + 1, 1.0f, textureWidth, textureHeight));
            }
        }
    }

    private void initmodel(JpmFile data, float[] parents, float scale) {
        float[] fArray = new float[3];
        float f = this.gen == 0 ? parents[0] - data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : (this.gen == 1 ? parents[0] + data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[0] ? -1 : 1) : (fArray[0] = data.getTranslate().get(0).floatValue() * (float)(this.invertAxis[1] ? -1 : 1)));
        float f2 = this.gen == 0 ? parents[1] - data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (this.gen == 1 ? parents[1] + data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1) : (fArray[1] = data.getTranslate().get(1).floatValue() * (float)(this.invertAxis[1] ? -1 : 1)));
        fArray[2] = this.gen == 0 ? parents[2] - data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : (this.gen == 1 ? parents[2] + data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1) : data.getTranslate().get(2).floatValue() * (float)(this.invertAxis[2] ? -1 : 1));
        float[] pivot = fArray;
        float[] translate = new float[]{data.getTranslate().get(0).floatValue(), data.getTranslate().get(1).floatValue(), data.getTranslate().get(2).floatValue()};
        if (data.getBoxes() != null) {
            for (JpmFile.JpmBox box : data.getBoxes()) {
                if (box.useUvMap()) {
                    this.model.addCuboid((box.getCoordinates().get(0).floatValue() + (this.gen == 0 ? translate[0] : 0.0f)) * (float)(this.invertAxis[0] ? -1 : 1) - (this.invertAxis[0] ? box.getCoordinates().get(3).floatValue() : 0.0f), (box.getCoordinates().get(1).floatValue() + (this.gen == 0 ? translate[1] : 0.0f)) * (float)(this.invertAxis[1] ? -1 : 1) - (this.invertAxis[1] ? box.getCoordinates().get(4).floatValue() : 0.0f), (box.getCoordinates().get(2).floatValue() + (this.gen == 0 ? translate[2] : 0.0f)) * (float)(this.invertAxis[2] ? -1 : 1) - (this.invertAxis[2] ? box.getCoordinates().get(5).floatValue() : 0.0f), box.getCoordinates().get(3).intValue(), box.getCoordinates().get(4).intValue(), box.getCoordinates().get(5).intValue(), box.getSizeAdd().floatValue(), data.getMirrorTexture()[0], data.getMirrorTexture()[1], box.getUv("north"), box.getUv("south"), box.getUv("east"), box.getUv("west"), box.getUv("up"), box.getUv("down"));
                    continue;
                }
                this.model.addCuboid((box.getCoordinates().get(0).floatValue() + (this.gen == 0 ? translate[0] : 0.0f)) * (float)(this.invertAxis[0] ? -1 : 1) - (this.invertAxis[0] ? box.getCoordinates().get(3).floatValue() : 0.0f), (box.getCoordinates().get(1).floatValue() + (this.gen == 0 ? translate[1] : 0.0f)) * (float)(this.invertAxis[1] ? -1 : 1) - (this.invertAxis[1] ? box.getCoordinates().get(4).floatValue() : 0.0f), (box.getCoordinates().get(2).floatValue() + (this.gen == 0 ? translate[2] : 0.0f)) * (float)(this.invertAxis[2] ? -1 : 1) - (this.invertAxis[2] ? box.getCoordinates().get(5).floatValue() : 0.0f), box.getCoordinates().get(3).intValue(), box.getCoordinates().get(4).intValue(), box.getCoordinates().get(5).intValue(), box.getSizeAdd().floatValue(), data.getMirrorTexture()[0], data.getMirrorTexture()[1], box.getTextureOffset().get(0).intValue(), box.getTextureOffset().get(1).intValue());
            }
        }
        this.model.method_2851(pivot[0], pivot[1], pivot[2]);
        this.model.setRotation(this.rotates[0], this.rotates[1], this.rotates[2]);
        this.model.setScale(scale, scale, scale);
    }

    private void addChild(CemModelEntry child) {
        ArrayList<String> key = new ArrayList<String>(Collections.singletonList(child.getId()));
        if (this.children.containsKey(key)) {
            throw new InvalidParameterException("Child " + key + " already exists for parent " + this.getId());
        }
        this.children.put(key, child);
        for (ArrayList<String> refs : child.children.keySet()) {
            CemModelEntry val = child.children.get(refs);
            refs.add(0, child.getId());
            this.children.put(refs, val);
        }
        this.model.addChild(child.getId(), child.getModel());
    }

    String getId() {
        return this.id;
    }

    public CemModelPart getModel() {
        return this.model;
    }

    String getPart() {
        return this.part;
    }

    void setTranslate(char axis, float requestedTranslate) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            switch (axis) {
                case 'x': {
                    float oldTranslate = this.translates[0];
                    this.translates[0] = requestedTranslate;
                    this.getModel().field_3657 += this.translates[0] - oldTranslate;
                    break;
                }
                case 'y': {
                    float oldTranslate = this.translates[1];
                    this.translates[1] = requestedTranslate;
                    this.getModel().field_3656 += this.translates[1] - oldTranslate;
                    break;
                }
                case 'z': {
                    float oldTranslate = this.translates[2];
                    this.translates[2] = requestedTranslate;
                    this.getModel().field_3655 += this.translates[2] - oldTranslate;
                }
            }
        } else {
            float currentTranslate = this.getTranslate(axis);
            switch (axis) {
                case 'x': {
                    this.getModel().field_3657 += requestedTranslate - currentTranslate;
                    this.offsets[0] = this.offsets[0] + (requestedTranslate - currentTranslate);
                    break;
                }
                case 'y': {
                    this.getModel().field_3656 += requestedTranslate - currentTranslate;
                    this.offsets[1] = this.offsets[1] + (requestedTranslate - currentTranslate);
                    break;
                }
                case 'z': {
                    this.getModel().field_3655 += requestedTranslate - currentTranslate;
                    this.offsets[2] = this.offsets[2] + (requestedTranslate - currentTranslate);
                }
            }
        }
    }

    public float getTranslate(char axis) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            return switch (axis) {
                case 'x' -> this.translates[0];
                case 'y' -> this.translates[1];
                case 'z' -> this.translates[2];
                default -> throw new IllegalStateException("Unknown axis \"" + axis + "\"");
            };
        }
        switch (axis) {
            case 'x': {
                float value;
                float f = value = this.gen != 0 ? this.translates[0] + this.offsets[0] : this.getModel().field_3657;
                if (this.getModel().parent != null) {
                    value += this.getModel().parent.field_3657;
                }
                return value;
            }
            case 'y': {
                float value;
                float f = value = this.gen != 0 ? this.translates[1] + this.offsets[1] : this.getModel().field_3656;
                if (this.getModel().parent != null) {
                    value += this.getModel().parent.field_3656;
                }
                return value;
            }
            case 'z': {
                float value;
                float f = value = this.gen != 0 ? this.translates[2] + this.offsets[2] : this.getModel().field_3655;
                if (this.getModel().parent != null) {
                    value += this.getModel().parent.field_3655;
                }
                return value;
            }
        }
        throw new IllegalStateException("Unknown axis \"" + axis + "\"");
    }

    void setRotate(char axis, float requestedAngle) {
        if (CemConfigFairy.getConfig().useOldAnimations()) {
            this.getModel().setRotation(axis, requestedAngle);
        } else {
            float angle = requestedAngle;
            if (this.getModel().parent != null) {
                angle -= this.getModel().parent.getRotation(axis);
            }
            this.getModel().setRotation(axis, angle);
        }
    }

    HashMap<ArrayList<String>, CemModelEntry> getChildren() {
        return this.children;
    }

    public static class CemModelPart
    extends class_630 {
        private final float[] scale;
        private final float[] rotation;
        private final int textureWidth;
        private final int textureHeight;
        private TransparentCemModelPart parent;

        public CemModelPart() {
            this(0, 0);
        }

        public CemModelPart(int textureWidth, int textureHeight) {
            super(new ArrayList(), new HashMap());
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
            this.scale = new float[]{1.0f, 1.0f, 1.0f};
            this.rotation = new float[]{0.0f, 0.0f, 0.0f};
        }

        public static CemModelPart of(class_630 modelPart) {
            CemModelPart yeet = modelPart instanceof CemModelPart ? new CemModelPart(((CemModelPart)modelPart).textureWidth, ((CemModelPart)modelPart).textureHeight) : new CemModelPart();
            for (String key : modelPart.field_3661.keySet()) {
                yeet.field_3661.put(key, CemModelPart.of((class_630)modelPart.field_3661.get(key)));
            }
            yeet.field_3663.addAll(modelPart.field_3663);
            yeet.method_17138(modelPart);
            yeet.field_3665 = modelPart.field_3665;
            return yeet;
        }

        public void addCuboid(float x, float y, float z, int sizeX, int sizeY, int sizeZ, float extra, boolean mirrorU, boolean mirrorV, int textureOffsetU, int textureOffsetV) {
            this.field_3663.add(new CemCuboid(x, y, z, sizeX, sizeY, sizeZ, extra, extra, extra, mirrorU, mirrorV, this.textureWidth, this.textureHeight, textureOffsetU, textureOffsetV));
        }

        public void addCuboid(float x, float y, float z, int sizeX, int sizeY, int sizeZ, float extra, boolean mirrorU, boolean mirrorV, float[] uvNorth, float[] uvSouth, float[] uvEast, float[] uvWest, float[] uvUp, float[] uvDown) {
            this.field_3663.add(new CemCuboid(x, y, z, sizeX, sizeY, sizeZ, extra, extra, extra, mirrorU, mirrorV, this.textureWidth, this.textureHeight, uvNorth, uvSouth, uvEast, uvWest, uvUp, uvDown));
        }

        public void setScale(float scaleX, float scaleY, float scaleZ) {
            this.scale[0] = scaleX;
            this.scale[1] = scaleY;
            this.scale[2] = scaleZ;
        }

        public void setRotation(float rotX, float rotY, float rotZ) {
            this.rotation[0] = rotX;
            this.rotation[1] = rotY;
            this.rotation[2] = rotZ;
        }

        public void setScale(char axis, float scale) {
            switch (axis) {
                case 'x': {
                    this.scale[0] = scale;
                    break;
                }
                case 'y': {
                    this.scale[1] = scale;
                    break;
                }
                case 'z': {
                    this.scale[2] = scale;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown axis \"" + axis + "\"");
                }
            }
        }

        public void setRotation(char axis, float rot) {
            switch (axis) {
                case 'x': {
                    this.rotation[0] = rot;
                    this.field_3654 = 0.0f;
                    break;
                }
                case 'y': {
                    this.rotation[1] = rot;
                    this.field_3675 = 0.0f;
                    break;
                }
                case 'z': {
                    this.rotation[2] = rot;
                    this.field_3674 = 0.0f;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown axis \"" + axis + "\"");
                }
            }
        }

        public float getScale(char axis) {
            return switch (axis) {
                case 'x' -> this.scale[0];
                case 'y' -> this.scale[1];
                case 'z' -> this.scale[2];
                default -> throw new IllegalStateException("Unknown axis \"" + axis + "\"");
            };
        }

        public float getRotation(char axis) {
            switch (axis) {
                case 'x': {
                    float angle = this.field_3654;
                    if (this.parent != null) {
                        angle += this.parent.field_3654;
                    }
                    return angle + this.rotation[0];
                }
                case 'y': {
                    float angle = this.field_3675;
                    if (this.parent != null) {
                        angle += this.parent.field_3675;
                    }
                    return angle + this.rotation[1];
                }
                case 'z': {
                    float angle = this.field_3674;
                    if (this.parent != null) {
                        angle += this.parent.field_3674;
                    }
                    return angle + this.rotation[2];
                }
            }
            throw new IllegalStateException("Unknown axis \"" + axis + "\"");
        }

        public void addChild(String name, class_630 modelPart) {
            this.field_3661.put(name, modelPart);
        }

        public void inflate(float scale) {
            this.field_3663.replaceAll(cuboid -> ((CemCuboid)((Object)cuboid)).inflate(scale));
            for (class_630 child : this.field_3661.values()) {
                ((CemModelPart)child).inflate(scale);
            }
        }

        public void method_17138(class_630 part) {
            super.method_17138(part);
            if (part instanceof CemModelPart) {
                for (int i = 0; i < 3; ++i) {
                    this.rotation[i] = ((CemModelPart)part).rotation[i];
                    this.scale[i] = ((CemModelPart)part).scale[i];
                }
                if (this.field_3661.keySet().equals(part.field_3661.keySet())) {
                    for (String key : part.field_3661.keySet()) {
                        ((class_630)this.field_3661.get(key)).method_17138((class_630)part.field_3661.get(key));
                    }
                }
            }
        }

        public class_630 method_32086(String name) {
            class_630 child = (class_630)this.field_3661.get(name);
            if (child == null) {
                this.field_3661.put(name, new CemModelPart());
                return this.method_32086(name);
            }
            return super.method_32086(name);
        }

        public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            matrices.method_22905(this.scale[0], this.scale[1], this.scale[2]);
            super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }

        public void method_22703(class_4587 matrix) {
            this.field_3654 += this.rotation[0];
            this.field_3675 += this.rotation[1];
            this.field_3674 += this.rotation[2];
            super.method_22703(matrix);
            this.field_3654 -= this.rotation[0];
            this.field_3675 -= this.rotation[1];
            this.field_3674 -= this.rotation[2];
        }

        private void setParent(TransparentCemModelPart transparentCemModelPart) {
            this.parent = transparentCemModelPart;
        }
    }

    public static class TransparentCemModelPart
    extends CemModelPart {
        private final CemModelPart part;

        public TransparentCemModelPart(class_630 part, class_5603 fakeTransform, class_5603 realTransform) {
            this.part = !(part instanceof CemModelPart) ? CemModelPart.of(part) : (CemModelPart)part;
            this.method_32085(realTransform);
            this.addChild("my_precious", part);
            this.part.field_3657 = part.field_3657 - fakeTransform.field_27702;
            this.part.field_3656 = part.field_3656 - fakeTransform.field_27703;
            this.part.field_3655 = part.field_3655 - fakeTransform.field_27704;
            this.part.setParent(this);
        }

        private TransparentCemModelPart(CemModelPart part) {
            this.part = part;
            this.addChild("my_precious", part);
        }

        public static TransparentCemModelPart of(TransparentCemModelPart modelPart) {
            TransparentCemModelPart yeet = new TransparentCemModelPart(CemModelPart.of(modelPart.part));
            yeet.method_17138(modelPart);
            yeet.field_3665 = modelPart.field_3665;
            return yeet;
        }

        @Override
        public class_630 method_32086(String name) {
            return this.part.method_32086(name);
        }

        @Override
        public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            class_5603 rotations = this.method_32084();
            this.part.field_3654 = rotations.field_27705;
            this.part.field_3675 = rotations.field_27706;
            this.part.field_3674 = rotations.field_27707;
            this.field_3654 = 0.0f;
            this.field_3675 = 0.0f;
            this.field_3674 = 0.0f;
            super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
            this.method_32085(rotations);
        }

        public void rotateInnerPart(class_4587 matrix) {
            this.rotateInnerPart(matrix, 0.0f, 0.0f, 0.0f);
        }

        public void rotateInnerPart(class_4587 matrix, float xOffset, float yOffset, float zOffset) {
            this.part.field_3657 += this.field_3657 + xOffset;
            this.part.field_3656 += this.field_3656 + yOffset;
            this.part.field_3655 += this.field_3655 + zOffset;
            this.part.method_22703(matrix);
            this.part.field_3657 -= this.field_3657 + xOffset;
            this.part.field_3656 -= this.field_3656 + yOffset;
            this.part.field_3655 -= this.field_3655 + zOffset;
        }
    }

    public static class CemCuboid
    extends class_630.class_628 {
        private final CemCuboidParams params;

        public CemCuboid(float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirrorU, boolean mirrorV, int textureWidth, int textureHeight, float[] uvNorth, float[] uvSouth, float[] uvEast, float[] uvWest, float[] uvUp, float[] uvDown) {
            super(0, 0, mirrorU ? x + sizeX : x, mirrorV ? y + sizeY : y, z, mirrorU ? -sizeX : sizeX, mirrorV ? -sizeY : sizeY, sizeZ, mirrorU ? -extraX : extraX, mirrorV ? -extraY : extraY, extraZ, false, (float)textureWidth, (float)textureHeight);
            this.params = new CemCuboidUvParams(x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirrorU, mirrorV, textureWidth, textureHeight, uvNorth, uvSouth, uvEast, uvWest, uvDown, uvUp);
            this.field_3649[4] = new class_630.class_593(this.field_3649[4].field_3502, uvNorth[0], uvNorth[1], uvNorth[2], uvNorth[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11043);
            this.field_3649[5] = new class_630.class_593(this.field_3649[5].field_3502, uvSouth[0], uvSouth[1], uvSouth[2], uvSouth[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11035);
            this.field_3649[0] = new class_630.class_593(this.field_3649[0].field_3502, uvEast[0], uvEast[1], uvEast[2], uvEast[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11034);
            this.field_3649[1] = new class_630.class_593(this.field_3649[1].field_3502, uvWest[0], uvWest[1], uvWest[2], uvWest[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11039);
            this.field_3649[2] = new class_630.class_593(this.field_3649[2].field_3502, uvDown[0], uvDown[1], uvDown[2], uvDown[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11033);
            this.field_3649[3] = new class_630.class_593(this.field_3649[3].field_3502, uvUp[0], uvUp[1], uvUp[2], uvUp[3], (float)textureWidth, (float)textureHeight, false, class_2350.field_11036);
        }

        public CemCuboid(float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirrorU, boolean mirrorV, int textureWidth, int textureHeight, int u, int v) {
            super(u, v, x, mirrorV ? y + sizeY : y, z, sizeX, mirrorV ? -sizeY : sizeY, sizeZ, extraX, extraY, extraZ, mirrorU, (float)textureWidth, (float)textureHeight);
            this.params = new CemCuboidTexOffsetParams(x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirrorU, mirrorV, textureWidth, textureHeight, u, v);
        }

        public CemCuboid inflate(float scale) {
            return this.params instanceof CemCuboidTexOffsetParams ? new CemCuboid(this.params.getX(), this.params.getY(), this.params.getZ(), this.params.getSizeX(), this.params.getSizeY(), this.params.getSizeZ(), scale + this.params.getExtraX(), scale + this.params.getExtraY(), scale + this.params.getExtraZ(), this.params.isMirrorU(), this.params.isMirrorV(), this.params.getTextureWidth(), this.params.getTextureHeight(), ((CemCuboidTexOffsetParams)this.params).getU(), ((CemCuboidTexOffsetParams)this.params).getV()) : new CemCuboid(this.params.getX(), this.params.getY(), this.params.getZ(), this.params.getSizeX(), this.params.getSizeY(), this.params.getSizeZ(), scale + this.params.getExtraX(), scale + this.params.getExtraY(), scale + this.params.getExtraZ(), this.params.isMirrorU(), this.params.isMirrorV(), this.params.getTextureWidth(), this.params.getTextureHeight(), ((CemCuboidUvParams)this.params).getUvNorth(), ((CemCuboidUvParams)this.params).getUvSouth(), ((CemCuboidUvParams)this.params).getUvEast(), ((CemCuboidUvParams)this.params).getUvWest(), ((CemCuboidUvParams)this.params).getUvUp(), ((CemCuboidUvParams)this.params).getUvDown());
        }

        public boolean isMirrorU() {
            return this.params.isMirrorU();
        }

        private static class CemCuboidUvParams
        extends CemCuboidParams {
            private final float[] uvNorth;
            private final float[] uvSouth;
            private final float[] uvEast;
            private final float[] uvWest;
            private final float[] uvDown;
            private final float[] uvUp;

            private CemCuboidUvParams(float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirrorU, boolean mirrorV, int textureWidth, int textureHeight, float[] uvNorth, float[] uvSouth, float[] uvEast, float[] uvWest, float[] uvDown, float[] uvUp) {
                super(x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirrorU, mirrorV, textureWidth, textureHeight);
                this.uvNorth = uvNorth;
                this.uvSouth = uvSouth;
                this.uvEast = uvEast;
                this.uvWest = uvWest;
                this.uvDown = uvDown;
                this.uvUp = uvUp;
            }

            private float[] getUvNorth() {
                return this.uvNorth;
            }

            private float[] getUvSouth() {
                return this.uvSouth;
            }

            private float[] getUvEast() {
                return this.uvEast;
            }

            private float[] getUvWest() {
                return this.uvWest;
            }

            private float[] getUvDown() {
                return this.uvDown;
            }

            private float[] getUvUp() {
                return this.uvUp;
            }
        }

        private static abstract class CemCuboidParams {
            private final float x;
            private final float y;
            private final float z;
            private final float sizeX;
            private final float sizeY;
            private final float sizeZ;
            private final float extraX;
            private final float extraY;
            private final float extraZ;
            private final boolean mirrorU;
            private final boolean mirrorV;
            private final int textureWidth;
            private final int textureHeight;

            private CemCuboidParams(float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirrorU, boolean mirrorV, int textureWidth, int textureHeight) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.sizeX = sizeX;
                this.sizeY = sizeY;
                this.sizeZ = sizeZ;
                this.extraX = extraX;
                this.extraY = extraY;
                this.extraZ = extraZ;
                this.mirrorU = mirrorU;
                this.mirrorV = mirrorV;
                this.textureWidth = textureWidth;
                this.textureHeight = textureHeight;
            }

            private float getX() {
                return this.x;
            }

            private float getY() {
                return this.y;
            }

            private float getZ() {
                return this.z;
            }

            private float getSizeX() {
                return this.sizeX;
            }

            private float getSizeY() {
                return this.sizeY;
            }

            private float getSizeZ() {
                return this.sizeZ;
            }

            private float getExtraX() {
                return this.extraX;
            }

            private float getExtraY() {
                return this.extraY;
            }

            private float getExtraZ() {
                return this.extraZ;
            }

            private boolean isMirrorU() {
                return this.mirrorU;
            }

            private boolean isMirrorV() {
                return this.mirrorV;
            }

            protected int getTextureWidth() {
                return this.textureWidth;
            }

            protected int getTextureHeight() {
                return this.textureHeight;
            }
        }

        private static class CemCuboidTexOffsetParams
        extends CemCuboidParams {
            private final int u;
            private final int v;

            private CemCuboidTexOffsetParams(float x, float y, float z, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, boolean mirrorU, boolean mirrorV, int textureWidth, int textureHeight, int u, int v) {
                super(x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, mirrorU, mirrorV, textureWidth, textureHeight);
                this.u = u;
                this.v = v;
            }

            private int getU() {
                return this.u;
            }

            private int getV() {
                return this.v;
            }
        }
    }
}

