/*
 * Decompiled with CFR 0.152.
 */
package net.dorianpb.cem.internal.file;

import com.google.gson.internal.LinkedTreeMap;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.dorianpb.cem.internal.util.CemFairy;
import org.jetbrains.annotations.Nullable;

public class JpmFile {
    private final String id;
    private final String texture;
    private final ArrayList<Double> textureSize;
    private final boolean[] invertAxis;
    private final ArrayList<Double> translate;
    private final ArrayList<Double> rotate;
    private final Boolean[] mirrorTexture;
    private final ArrayList<JpmBox> boxes;
    private final ArrayList<JpmSprite> sprites;
    private final ArrayList<JpmFile> submodels;

    public JpmFile(LinkedTreeMap json) {
        this.id = CemFairy.JSONparseString(json.get((Object)"id"));
        this.texture = CemFairy.JSONparseString(json.get((Object)"texture"));
        this.textureSize = CemFairy.JSONparseDoubleList(json.get((Object)"textureSize"));
        String axes = CemFairy.JSONparseString(json.getOrDefault((Object)"invertAxis", (Object)""));
        this.invertAxis = new boolean[]{axes.contains("x"), axes.contains("y"), axes.contains("z")};
        this.translate = CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"translate", new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0))));
        this.rotate = CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"rotate", new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0))));
        for (int i = 0; i < Objects.requireNonNull(this.rotate).size(); ++i) {
            this.rotate.set(i, -Math.toRadians(this.rotate.get(i)));
        }
        String mirror = CemFairy.JSONparseString(json.getOrDefault((Object)"mirrorTexture", (Object)""));
        this.mirrorTexture = new Boolean[]{mirror.contains("u"), mirror.contains("v")};
        if (json.containsKey((Object)"boxes")) {
            this.boxes = new ArrayList();
            for (LinkedTreeMap cube : (ArrayList)json.get((Object)"boxes")) {
                this.boxes.add(new JpmBox(cube));
            }
        } else {
            this.boxes = null;
        }
        if (json.containsKey((Object)"sprites")) {
            this.sprites = new ArrayList();
            for (LinkedTreeMap sprite : (ArrayList)json.get((Object)"sprites")) {
                this.sprites.add(new JpmSprite(sprite));
            }
        } else {
            this.sprites = null;
        }
        if (json.containsKey((Object)"submodel") || json.containsKey((Object)"submodels")) {
            this.submodels = new ArrayList();
            if (json.containsKey((Object)"submodel")) {
                this.submodels.add(new JpmFile((LinkedTreeMap)json.get((Object)"submodel")));
            }
            if (json.containsKey((Object)"submodels")) {
                for (LinkedTreeMap submodel : (ArrayList)json.get((Object)"submodels")) {
                    this.submodels.add(new JpmFile(submodel));
                }
            }
        } else {
            this.submodels = null;
        }
    }

    public ArrayList<JpmBox> getBoxes() {
        return this.boxes;
    }

    public ArrayList<Double> getTranslate() {
        return this.translate;
    }

    public boolean[] getInvertAxis() {
        return this.invertAxis;
    }

    public ArrayList<JpmFile> getSubmodels() {
        return this.submodels;
    }

    public ArrayList<Double> getRotate() {
        return this.rotate;
    }

    public String getId() {
        return this.id;
    }

    public Boolean[] getMirrorTexture() {
        return this.mirrorTexture;
    }

    public static class JpmBox {
        private final ArrayList<Double> textureOffset;
        private final ArrayList<Double> uvUp;
        private final ArrayList<Double> uvDown;
        private final ArrayList<Double> uvFront;
        private final ArrayList<Double> uvBack;
        private final ArrayList<Double> uvLeft;
        private final ArrayList<Double> uvRight;
        private final ArrayList<Double> coordinates;
        private final Double sizeAdd;

        JpmBox(LinkedTreeMap json) {
            this.textureOffset = CemFairy.JSONparseDoubleList(json.get((Object)"textureOffset"));
            this.uvUp = this.getNull(CemFairy.JSONparseDoubleList(json.get((Object)"uvUp")));
            this.uvDown = this.getNull(CemFairy.JSONparseDoubleList(json.get((Object)"uvDown")));
            this.uvFront = this.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvFront", json.get((Object)"uvNorth"))));
            this.uvBack = this.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvBack", json.get((Object)"uvSouth"))));
            this.uvLeft = this.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvLeft", json.get((Object)"uvWest"))));
            this.uvRight = this.getNull(CemFairy.JSONparseDoubleList(json.getOrDefault((Object)"uvRight", json.get((Object)"uvEast"))));
            this.coordinates = CemFairy.JSONparseDoubleList(json.get((Object)"coordinates"));
            this.sizeAdd = (Double)json.getOrDefault((Object)"sizeAdd", (Object)0.0);
            this.validate();
        }

        private ArrayList<Double> getNull(@Nullable ArrayList<Double> obj) {
            return obj == null ? new ArrayList() : obj;
        }

        private void validate() {
            if (this.textureOffset == null) {
                boolean triedToUseUV = false;
                for (ArrayList uvCoords : new ArrayList[]{this.uvUp, this.uvDown, this.uvFront, this.uvBack, this.uvLeft, this.uvRight}) {
                    triedToUseUV = triedToUseUV || uvCoords.size() == 4;
                }
                if (!triedToUseUV) {
                    throw new InvalidParameterException("Either \"textureOffset\" or at least one of the uv directions are required!");
                }
                ArrayList<Double> doubles = new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0, 0.0));
                boolean warn = false;
                for (ArrayList uvCoords : new ArrayList[]{this.uvUp, this.uvDown, this.uvFront, this.uvBack, this.uvLeft, this.uvRight}) {
                    if (uvCoords.size() != 0) continue;
                    uvCoords.addAll(doubles);
                    warn = true;
                }
                if (warn) {
                    CemFairy.getLogger().warn("\tthe above file didn't specify all uv directions!");
                }
            }
            if (this.coordinates == null) {
                throw new InvalidParameterException("Element \"coordinates\" is required");
            }
        }

        public boolean useUvMap() {
            return this.textureOffset == null;
        }

        public ArrayList<Double> getTextureOffset() {
            return this.textureOffset;
        }

        public ArrayList<Double> getCoordinates() {
            return this.coordinates;
        }

        public Double getSizeAdd() {
            return this.sizeAdd;
        }

        public float[] getUv(String direction) {
            float[] fArray;
            switch (direction.toLowerCase()) {
                case "down": {
                    float[] fArray2 = new float[4];
                    fArray2[0] = this.uvUp.get(0).floatValue();
                    fArray2[1] = this.uvUp.get(1).floatValue();
                    fArray2[2] = this.uvUp.get(2).floatValue();
                    fArray = fArray2;
                    fArray2[3] = this.uvUp.get(3).floatValue();
                    break;
                }
                case "up": {
                    float[] fArray3 = new float[4];
                    fArray3[0] = this.uvDown.get(0).floatValue();
                    fArray3[1] = this.uvDown.get(1).floatValue();
                    fArray3[2] = this.uvDown.get(2).floatValue();
                    fArray = fArray3;
                    fArray3[3] = this.uvDown.get(3).floatValue();
                    break;
                }
                case "front": 
                case "north": {
                    float[] fArray4 = new float[4];
                    fArray4[0] = this.uvFront.get(0).floatValue();
                    fArray4[1] = this.uvFront.get(1).floatValue();
                    fArray4[2] = this.uvFront.get(2).floatValue();
                    fArray = fArray4;
                    fArray4[3] = this.uvFront.get(3).floatValue();
                    break;
                }
                case "back": 
                case "south": {
                    float[] fArray5 = new float[4];
                    fArray5[0] = this.uvBack.get(0).floatValue();
                    fArray5[1] = this.uvBack.get(1).floatValue();
                    fArray5[2] = this.uvBack.get(2).floatValue();
                    fArray = fArray5;
                    fArray5[3] = this.uvBack.get(3).floatValue();
                    break;
                }
                case "right": 
                case "east": {
                    float[] fArray6 = new float[4];
                    fArray6[0] = this.uvLeft.get(0).floatValue();
                    fArray6[1] = this.uvLeft.get(1).floatValue();
                    fArray6[2] = this.uvLeft.get(2).floatValue();
                    fArray = fArray6;
                    fArray6[3] = this.uvLeft.get(3).floatValue();
                    break;
                }
                case "left": 
                case "west": {
                    float[] fArray7 = new float[4];
                    fArray7[0] = this.uvRight.get(0).floatValue();
                    fArray7[1] = this.uvRight.get(1).floatValue();
                    fArray7[2] = this.uvRight.get(2).floatValue();
                    fArray = fArray7;
                    fArray7[3] = this.uvRight.get(3).floatValue();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + direction);
                }
            }
            return fArray;
        }
    }

    static class JpmSprite {
        private final ArrayList<Integer> textureOffset;
        private final ArrayList<Integer> coordinates;
        private final Double sizeAdd;

        JpmSprite(LinkedTreeMap json) {
            this.textureOffset = (ArrayList)json.get((Object)"textureOffset");
            this.coordinates = (ArrayList)json.get((Object)"coordinates");
            this.sizeAdd = (Double)json.get((Object)"sizeAdd");
        }
    }
}

