/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.minecraft.class_3542;

public class StringIdentifiableTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class cls = type.getRawType();
        if (cls.isEnum()) {
            Class<?>[] implemented;
            for (Class<?> iface : implemented = cls.getInterfaces()) {
                if (iface != class_3542.class) continue;
                return new StringIdentifiableTypeAdapter(cls);
            }
        }
        return null;
    }

    private static class StringIdentifiableTypeAdapter<T extends Enum<T>>
    extends TypeAdapter<T> {
        private final T[] values;

        StringIdentifiableTypeAdapter(Class<?> cls) {
            this.values = (Enum[])cls.getEnumConstants();
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(((class_3542)value).method_15434());
            }
        }

        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                throw new JsonSyntaxException((Throwable)new NullPointerException("Required nonnull"));
            }
            String name = in.nextString();
            for (T t : this.values) {
                if (!((class_3542)t).method_15434().equals(name)) continue;
                return t;
            }
            throw new JsonSyntaxException((Throwable)new IllegalArgumentException(name));
        }
    }
}

