/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties.adapter;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.kvverti.colormatic.properties.ApplicableBlockStates;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicableBlockStatesAdapter
extends TypeAdapter<ApplicableBlockStates> {
    private static final Logger logger = LogManager.getLogger();

    public void write(JsonWriter out, ApplicableBlockStates value) throws IOException {
        throw new UnsupportedOperationException("write");
    }

    public ApplicableBlockStates read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            throw new JsonSyntaxException("required nonnull");
        }
        String s = in.nextString();
        return ApplicableBlockStatesAdapter.from(s);
    }

    private static ApplicableBlockStates from(String blockDesc) {
        class_2248 b;
        ApplicableBlockStates res = new ApplicableBlockStates();
        String[] parts = blockDesc.split(":");
        try {
            if (parts.length > 1 && parts[1].indexOf(61) < 0) {
                class_2960 id = new class_2960(parts[0], parts[1]);
                if (parts[0].equals("colormatic")) {
                    ApplicableBlockStatesAdapter.initSpecialBlockStates(res, id, parts);
                    return res;
                }
                b = (class_2248)class_2378.field_11146.method_10223(id);
                bgnIdx = 2;
            } else {
                b = (class_2248)class_2378.field_11146.method_10223(new class_2960(parts[0]));
                bgnIdx = 1;
            }
        }
        catch (class_151 e) {
            throw new JsonSyntaxException("Invalid block identifier: " + blockDesc, (Throwable)e);
        }
        res.block = b;
        class_2715 pred = class_2715.method_11758((class_2248)b);
        for (int i = bgnIdx; i < parts.length; ++i) {
            int split = parts[i].indexOf(61);
            if (split < 0) {
                throw new JsonSyntaxException("Invalid property syntax: " + parts[i]);
            }
            String propStr = parts[i].substring(0, split);
            class_2769 prop = null;
            for (class_2769 p : b.method_9564().method_28501()) {
                if (!p.method_11899().equals(propStr)) continue;
                prop = p;
                break;
            }
            if (prop == null) {
                throw new JsonSyntaxException("Invalid property: " + propStr);
            }
            String[] propValues = parts[i].substring(split + 1).split(",");
            ArrayList ls = new ArrayList();
            for (String s : propValues) {
                ApplicableBlockStatesAdapter.putPropValue(prop, s, ls);
            }
            pred = pred.method_11762(prop, ls::contains);
        }
        res.states = new ArrayList<class_2680>();
        boolean excluded = false;
        for (class_2680 state : b.method_9595().method_11662()) {
            if (pred.method_11760(state)) {
                res.states.add(state);
                continue;
            }
            excluded = true;
        }
        if (!excluded) {
            res.states.clear();
        }
        return res;
    }

    private static void initSpecialBlockStates(ApplicableBlockStates res, class_2960 id, String[] parts) {
        res.specialKey = id;
        if (parts.length != 3) {
            logger.warn("Special identifier does not specify sole property: {}", (Object)Arrays.toString(parts));
        } else {
            for (int i = 2; i < parts.length; ++i) {
                String[] propValues;
                int split = parts[i].indexOf(61);
                if (split < 0) {
                    throw new JsonSyntaxException("Invalid property syntax: " + parts[i]);
                }
                for (String value : propValues = parts[i].substring(split + 1).split(",")) {
                    class_2960 val = class_2960.method_12829((String)value.replaceFirst("/", ":"));
                    if (val == null) {
                        throw new JsonSyntaxException("Invalid identifier value: " + value);
                    }
                    res.specialIds.add(val);
                }
            }
        }
    }

    private static <T extends Comparable<T>> void putPropValue(class_2769<T> prop, String s, List<? super T> values) {
        Optional value = prop.method_11900(s);
        if (!value.isPresent()) {
            throw new JsonSyntaxException("Invalid property value: " + s);
        }
        values.add(value.get());
    }
}

