/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import com.google.gson.JsonParseException;
import io.github.kvverti.colormatic.properties.ColormapProperties;
import io.github.kvverti.colormatic.properties.HexColor;
import io.github.kvverti.colormatic.properties.PropertyUtil;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class GlobalColorProperties {
    private static final Logger log = LogManager.getLogger();
    public static final GlobalColorProperties DEFAULT = new GlobalColorProperties(new Settings());
    private final Map<ColoredParticle, HexColor> particle;
    private final Map<class_2960, HexColor> dimensionFog;
    private final Map<class_2960, HexColor> dimensionSky;
    private final int lilypad;
    private final Map<class_1291, HexColor> potions;
    private final Map<class_1767, HexColor> sheep;
    private final Map<class_1767, float[]> sheepRgb;
    private final Map<class_1767, HexColor> collar;
    private final Map<class_1767, float[]> collarRgb;
    private final Map<class_1767, HexColor> banner;
    private final Map<class_1767, float[]> bannerRgb;
    private final Map<class_3620, HexColor> map;
    private final Map<class_1299<?>, int[]> spawnEgg;
    private final Map<class_124, class_5251> textColor;
    private final TextColorSettings text;
    private final int xpOrbTime;
    private final ColormapProperties.Format defaultFormat;
    @Nullable
    private final ColormapProperties.ColumnLayout defaultLayout;
    private static final Map<String, String> keyRemap = new HashMap<String, String>();

    private GlobalColorProperties(Settings settings) {
        this.particle = settings.particle;
        this.dimensionFog = this.convertIdMap(settings.fog);
        this.dimensionSky = this.convertIdMap(settings.sky);
        this.lilypad = settings.lilypad != null ? settings.lilypad.rgb() : 0;
        this.potions = GlobalColorProperties.convertMap(settings.potion, class_2378.field_11159);
        this.sheep = settings.sheep;
        this.sheepRgb = GlobalColorProperties.toRgb(settings.sheep);
        this.collar = settings.collar;
        this.collarRgb = GlobalColorProperties.toRgb(settings.collar);
        this.banner = settings.banner;
        this.bannerRgb = GlobalColorProperties.toRgb(settings.banner);
        this.map = settings.map;
        this.spawnEgg = GlobalColorProperties.collateSpawnEggColors(settings);
        this.xpOrbTime = settings.xporb.time;
        if (settings.text != null) {
            TextColorSettings text = settings.text;
            this.textColor = new HashMap<class_124, class_5251>();
            for (Map.Entry<Integer, HexColor> entry : text.code.entrySet()) {
                int code = entry.getKey();
                if (code >= 16) continue;
                class_124 color = class_124.method_534((int)code);
                this.textColor.put(color, class_5251.method_27717((int)entry.getValue().rgb()));
            }
            for (Map.Entry<Integer, HexColor> entry : text.format.entrySet()) {
                this.textColor.put((class_124)entry.getKey(), class_5251.method_27717((int)entry.getValue().rgb()));
            }
            text.code = Collections.emptyMap();
            text.format = Collections.emptyMap();
            this.text = text;
        } else {
            this.textColor = Collections.emptyMap();
            this.text = new TextColorSettings();
        }
        this.defaultFormat = settings.palette.format;
        this.defaultLayout = settings.palette.layout;
        HexColor water = settings.potion.get("water");
        if (water == null) {
            water = settings.potion.get("minecraft:water");
        }
        if (water != null) {
            this.potions.put(null, water);
        }
    }

    private Map<class_2960, HexColor> convertIdMap(Map<String, HexColor> map) {
        HashMap<class_2960, HexColor> res = new HashMap<class_2960, HexColor>();
        for (Map.Entry<String, HexColor> entry : map.entrySet()) {
            class_2960 id = class_2960.method_12829((String)entry.getKey());
            if (id == null) continue;
            res.put(id, entry.getValue());
        }
        return res;
    }

    private static <T> Map<T, HexColor> convertMap(Map<String, HexColor> initial, class_2378<T> registry) {
        HashMap<Object, HexColor> res = new HashMap<Object, HexColor>();
        for (Map.Entry<String, HexColor> entry : initial.entrySet()) {
            Object key = registry.method_10223(class_2960.method_12829((String)entry.getKey()));
            if (key == null) continue;
            res.put(key, entry.getValue());
        }
        return res;
    }

    private static <T> Map<T, float[]> toRgb(Map<T, HexColor> map) {
        HashMap<T, float[]> res = new HashMap<T, float[]>();
        for (Map.Entry<T, HexColor> entry : map.entrySet()) {
            int col = entry.getValue().rgb();
            float[] rgb = new float[]{(float)(col >> 16 & 0xFF) / 255.0f, (float)(col >> 8 & 0xFF) / 255.0f, (float)(col & 0xFF) / 255.0f};
            res.put(entry.getKey(), rgb);
        }
        return res;
    }

    private static Map<class_1299<?>, int[]> collateSpawnEggColors(Settings settings) {
        HashMap res = new HashMap();
        class_2348 registry = class_2378.field_11145;
        if (settings.egg != null) {
            class_1299 type;
            LegacyEggColor legacy = settings.egg;
            for (Map.Entry<String, HexColor> entry : legacy.shell.entrySet()) {
                type = (class_1299)registry.method_10223(class_2960.method_12829((String)entry.getKey()));
                res.put(type, new int[]{entry.getValue().rgb(), 0});
            }
            for (Map.Entry<String, HexColor> entry : legacy.spots.entrySet()) {
                type = (class_1299)registry.method_10223(class_2960.method_12829((String)entry.getKey()));
                int[] colors = res.computeIfAbsent(type, t -> new int[2]);
                colors[1] = entry.getValue().rgb();
            }
        }
        for (Map.Entry<String, HexColor[]> entry : settings.spawnegg.entrySet()) {
            class_1299 type = (class_1299)registry.method_10223(class_2960.method_12829((String)entry.getKey()));
            int[] colors = res.computeIfAbsent(type, t -> new int[2]);
            HexColor[] hexColors = entry.getValue();
            for (int i = 0; i < Math.min(2, hexColors.length); ++i) {
                colors[i] = hexColors[i].rgb();
            }
        }
        return res;
    }

    private static <T> int getColor(T key, Map<T, HexColor> map) {
        HexColor col = map.get(key);
        return col != null ? col.rgb() : 0;
    }

    public int getParticle(ColoredParticle part) {
        return GlobalColorProperties.getColor(part, this.particle);
    }

    public int getDimensionFog(class_2960 dimId) {
        return GlobalColorProperties.getColor(dimId, this.dimensionFog);
    }

    public int getDimensionSky(class_2960 dimId) {
        return GlobalColorProperties.getColor(dimId, this.dimensionSky);
    }

    public int getLilypad() {
        return this.lilypad;
    }

    public int getPotion(class_1291 effect) {
        return GlobalColorProperties.getColor(effect, this.potions);
    }

    public int getWool(class_1767 color) {
        return GlobalColorProperties.getColor(color, this.sheep);
    }

    public float[] getWoolRgb(class_1767 color) {
        return this.sheepRgb.get(color);
    }

    public int getCollar(class_1767 color) {
        return GlobalColorProperties.getColor(color, this.collar);
    }

    public float[] getCollarRgb(class_1767 color) {
        return this.collarRgb.get(color);
    }

    public int getBanner(class_1767 color) {
        return GlobalColorProperties.getColor(color, this.banner);
    }

    public float[] getBannerRgb(class_1767 color) {
        return this.bannerRgb.get(color);
    }

    public int getMap(class_3620 color) {
        return GlobalColorProperties.getColor(color, this.map);
    }

    public int getSpawnEgg(class_1299<?> type, int idx) {
        int[] colors = this.spawnEgg.get(type);
        return colors != null ? colors[idx] : 0;
    }

    private int getColor(HexColor col) {
        return col != null ? col.rgb() : 0;
    }

    public int getXpText() {
        return this.getColor(this.text.xpbar);
    }

    public int getButtonTextHovered() {
        return this.getColor(this.text.button.hover);
    }

    public int getButtonTextDisabled() {
        return this.getColor(this.text.button.disabled);
    }

    public int getSignText(class_1767 color) {
        return GlobalColorProperties.getColor(color, this.text.sign);
    }

    public class_5251 getText(class_124 color) {
        return this.textColor.get(color);
    }

    public int getXpOrbTime() {
        return this.xpOrbTime;
    }

    public ColormapProperties.Format getDefaultFormat() {
        return this.defaultFormat;
    }

    @Nullable
    public ColormapProperties.ColumnLayout getDefaultLayout() {
        return this.defaultLayout;
    }

    /*
     * Exception decompiling
     */
    public static GlobalColorProperties load(class_3300 manager, class_2960 id, boolean fall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static GlobalColorProperties loadFromJson(Reader rd, class_2960 id) {
        Settings settings;
        try {
            settings = (Settings)PropertyUtil.PROPERTY_GSON.fromJson(rd, Settings.class);
            if (settings == null) {
                settings = new Settings();
            }
        }
        catch (JsonParseException e) {
            log.error("Error parsing {}: {}", (Object)id, (Object)e.getMessage());
            settings = new Settings();
        }
        return new GlobalColorProperties(settings);
    }

    private static /* synthetic */ boolean lambda$load$3(String k) {
        return false;
    }

    private static /* synthetic */ String lambda$load$2(String k) {
        return keyRemap.getOrDefault(k, k);
    }

    static {
        keyRemap.put("nether", "the_nether");
        keyRemap.put("end", "the_end");
        keyRemap.put("lightBlue", "light_blue");
        keyRemap.put("silver", "light_gray");
        keyRemap.put("moveSpeed", "speed");
        keyRemap.put("moveSlowdown", "slowness");
        keyRemap.put("digSpeed", "haste");
        keyRemap.put("digSlowDown", "mining_fatigue");
        keyRemap.put("damageBoost", "strength");
        keyRemap.put("heal", "instant_health");
        keyRemap.put("harm", "instant_damage");
        keyRemap.put("jump", "jump_boost");
        keyRemap.put("confusion", "nausea");
        keyRemap.put("fireResistance", "fire_resistance");
        keyRemap.put("waterBreathing", "water_breathing");
        keyRemap.put("nightVision", "night_vision");
        keyRemap.put("healthBoost", "health_boost");
    }

    private static class Settings {
        Map<ColoredParticle, HexColor> particle = Collections.emptyMap();
        Map<String, HexColor> fog = Collections.emptyMap();
        Map<String, HexColor> sky = Collections.emptyMap();
        HexColor lilypad;
        Map<String, HexColor> potion = Collections.emptyMap();
        Map<class_1767, HexColor> sheep = Collections.emptyMap();
        Map<class_1767, HexColor> collar = Collections.emptyMap();
        Map<class_3620, HexColor> map = Collections.emptyMap();
        Map<class_1767, HexColor> banner = Collections.emptyMap();
        Map<String, HexColor[]> spawnegg = Collections.emptyMap();
        LegacyEggColor egg;
        TextColorSettings text;
        XpOrb xporb = XpOrb.DEFAULT;
        Palette palette = Palette.DEFAULT;

        private Settings() {
        }
    }

    private static class XpOrb {
        static XpOrb DEFAULT = new XpOrb();
        int time = 628;

        private XpOrb() {
        }
    }

    private static class TextColorSettings {
        HexColor xpbar;
        ButtonText button = new ButtonText();
        Map<class_1767, HexColor> sign = Collections.emptyMap();
        Map<class_124, HexColor> format = Collections.emptyMap();
        Map<Integer, HexColor> code = Collections.emptyMap();

        private TextColorSettings() {
        }

        static class ButtonText {
            HexColor hover;
            HexColor disabled;

            ButtonText() {
            }
        }
    }

    private static class Palette {
        static Palette DEFAULT = new Palette();
        ColormapProperties.Format format = ColormapProperties.Format.VANILLA;
        @Nullable
        ColormapProperties.ColumnLayout layout = null;

        private Palette() {
        }
    }

    private static class LegacyEggColor {
        Map<String, HexColor> shell = Collections.emptyMap();
        Map<String, HexColor> spots = Collections.emptyMap();

        private LegacyEggColor() {
        }
    }

    public static enum ColoredParticle implements class_3542
    {
        WATER("water"),
        LAVA("lava"),
        PORTAL("portal");

        private final String name;

        private ColoredParticle(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

