/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import io.github.kvverti.colormatic.properties.ColormapProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DefaultColumns {
    private static final Logger log = LogManager.getLogger();
    private static final Map<class_2960, class_2960> dynamicColumns = new HashMap<class_2960, class_2960>();
    private static final Map<class_2960, ColormapProperties.ColumnBounds> currentColumns = DefaultColumns.createCurrentColumnBounds();
    private static final Map<class_2960, ColormapProperties.ColumnBounds> legacyColumns = DefaultColumns.createLegacyColumnBounds();
    private static final Map<class_2960, ColormapProperties.ColumnBounds> stableColumns = DefaultColumns.createStableColumnBounds();
    private static final int VANILLA_BIOME_COUNT = class_5458.field_25933.method_10204();
    private static final int LEGACY_1_17_BIOME_COUNT = 176;

    private DefaultColumns() {
    }

    public static ColormapProperties.ColumnBounds getDefaultBounds(class_5321<class_1959> biomeKey) {
        ColormapProperties.ColumnBounds bounds = currentColumns.get(biomeKey.method_29177());
        if (bounds == null && (bounds = currentColumns.get(DefaultColumns.approximateToVanilla(biomeKey))) == null) {
            String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        return bounds;
    }

    public static ColormapProperties.ColumnBounds getOptifineBounds(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry) {
        ColormapProperties.ColumnBounds bounds = currentColumns.get(biomeKey.method_29177());
        if (bounds == null) {
            int rawID = biomeRegistry.method_10206((Object)((class_1959)biomeRegistry.method_29107(biomeKey)));
            return new ColormapProperties.ColumnBounds(rawID, 1);
        }
        return bounds;
    }

    public static ColormapProperties.ColumnBounds getLegacyBounds(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry, boolean optifine) {
        ColormapProperties.ColumnBounds bounds = legacyColumns.get(biomeKey.method_29177());
        if (bounds == null) {
            if (optifine) {
                int rawID = biomeRegistry.method_10206((Object)((class_1959)biomeRegistry.method_29107(biomeKey)));
                return new ColormapProperties.ColumnBounds(rawID - VANILLA_BIOME_COUNT + 176, 1);
            }
            bounds = legacyColumns.get(DefaultColumns.approximateToVanilla(biomeKey));
            if (bounds == null) {
                String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
                log.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        return bounds;
    }

    public static ColormapProperties.ColumnBounds getStableBounds(class_5321<class_1959> biomeKey) {
        ColormapProperties.ColumnBounds bounds = stableColumns.get(biomeKey.method_29177());
        if (bounds == null && (bounds = stableColumns.get(DefaultColumns.approximateToVanilla(biomeKey))) == null) {
            String msg = "Custom biome has no approximate: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        return bounds;
    }

    private static class_2960 approximateToVanilla(class_5321<class_1959> biomeKey) {
        class_2960 id = dynamicColumns.get(biomeKey.method_29177());
        if (id == null) {
            String msg = "No column bounds for dynamic biome: " + biomeKey.method_29177();
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return id;
    }

    public static void reloadDefaultColumnBounds(class_5455 manager) {
        dynamicColumns.clear();
        if (manager != null) {
            class_2378 biomeRegistry = manager.method_30530(class_2378.field_25114);
            for (Map.Entry entry : biomeRegistry.method_29722()) {
                class_5321 key = (class_5321)entry.getKey();
                if (currentColumns.containsKey(key.method_29177())) continue;
                dynamicColumns.put(key.method_29177(), DefaultColumns.computeClosestDefaultBiome((class_5321<class_1959>)key, (class_2378<class_1959>)biomeRegistry));
            }
        }
    }

    private static class_2960 computeClosestDefaultBiome(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry) {
        class_1959 customBiome = (class_1959)biomeRegistry.method_29107(biomeKey);
        if (customBiome == null) {
            throw new IllegalStateException("Biome is not registered: " + biomeKey.method_29177());
        }
        double temperature = customBiome.method_8712();
        double humidity = class_3532.method_15350((double)customBiome.method_8715(), (double)0.0, (double)1.0);
        double minDistanceSq = Double.POSITIVE_INFINITY;
        class_2960 minBiomeId = null;
        for (Map.Entry<class_2960, ColormapProperties.ColumnBounds> entry : currentColumns.entrySet()) {
            double dHumidity;
            class_1959 vanillaBiome = (class_1959)biomeRegistry.method_10223(entry.getKey());
            if (vanillaBiome == null) {
                log.error("Vanilla biome is not registered????? : {}", (Object)entry.getKey());
                continue;
            }
            double dTemperature = temperature - (double)vanillaBiome.method_8712();
            double thisDistanceSq = dTemperature * dTemperature + (dHumidity = humidity - class_3532.method_15350((double)vanillaBiome.method_8715(), (double)0.0, (double)1.0)) * dHumidity;
            if (!(thisDistanceSq < minDistanceSq)) continue;
            minDistanceSq = thisDistanceSq;
            minBiomeId = entry.getKey();
        }
        return minBiomeId;
    }

    private static Map<class_2960, ColormapProperties.ColumnBounds> createCurrentColumnBounds() {
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        for (class_1959 biome : class_5458.field_25933) {
            class_2960 id = class_5458.field_25933.method_10221((Object)biome);
            int rawId = class_5458.field_25933.method_10206((Object)biome);
            map.put(id, new ColormapProperties.ColumnBounds(rawId, 1));
        }
        return map;
    }

    private static Map<class_2960, ColormapProperties.ColumnBounds> createLegacyColumnBounds() {
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        map.put(class_1972.field_9423.method_29177(), new ColormapProperties.ColumnBounds(0, 1));
        map.put(class_1972.field_9451.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_9424.method_29177(), new ColormapProperties.ColumnBounds(2, 1));
        map.put(class_1972.field_35116.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_9409.method_29177(), new ColormapProperties.ColumnBounds(4, 1));
        map.put(class_1972.field_9420.method_29177(), new ColormapProperties.ColumnBounds(5, 1));
        map.put(class_1972.field_9471.method_29177(), new ColormapProperties.ColumnBounds(6, 1));
        map.put(class_1972.field_9438.method_29177(), new ColormapProperties.ColumnBounds(7, 1));
        map.put(class_1972.field_9461.method_29177(), new ColormapProperties.ColumnBounds(8, 1));
        map.put(class_1972.field_9411.method_29177(), new ColormapProperties.ColumnBounds(9, 1));
        map.put(class_1972.field_9435.method_29177(), new ColormapProperties.ColumnBounds(10, 1));
        map.put(class_1972.field_9463.method_29177(), new ColormapProperties.ColumnBounds(11, 1));
        map.put(class_1972.field_35117.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_9462.method_29177(), new ColormapProperties.ColumnBounds(14, 1));
        map.put(class_1972.field_9434.method_29177(), new ColormapProperties.ColumnBounds(16, 1));
        map.put(class_1972.field_9417.method_29177(), new ColormapProperties.ColumnBounds(21, 1));
        map.put(class_1972.field_35118.method_29177(), new ColormapProperties.ColumnBounds(23, 1));
        map.put(class_1972.field_9446.method_29177(), new ColormapProperties.ColumnBounds(24, 1));
        map.put(class_1972.field_9419.method_29177(), new ColormapProperties.ColumnBounds(25, 1));
        map.put(class_1972.field_9478.method_29177(), new ColormapProperties.ColumnBounds(26, 1));
        map.put(class_1972.field_9412.method_29177(), new ColormapProperties.ColumnBounds(27, 1));
        map.put(class_1972.field_9475.method_29177(), new ColormapProperties.ColumnBounds(29, 1));
        map.put(class_1972.field_9454.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_35119.method_29177(), new ColormapProperties.ColumnBounds(32, 1));
        map.put(class_1972.field_35120.method_29177(), new ColormapProperties.ColumnBounds(34, 1));
        map.put(class_1972.field_9449.method_29177(), new ColormapProperties.ColumnBounds(35, 1));
        map.put(class_1972.field_9430.method_29177(), new ColormapProperties.ColumnBounds(36, 1));
        map.put(class_1972.field_9415.method_29177(), new ColormapProperties.ColumnBounds(37, 1));
        map.put(class_1972.field_35110.method_29177(), new ColormapProperties.ColumnBounds(38, 1));
        map.put(class_1972.field_9457.method_29177(), new ColormapProperties.ColumnBounds(40, 1));
        map.put(class_1972.field_9447.method_29177(), new ColormapProperties.ColumnBounds(41, 1));
        map.put(class_1972.field_9442.method_29177(), new ColormapProperties.ColumnBounds(42, 1));
        map.put(class_1972.field_9465.method_29177(), new ColormapProperties.ColumnBounds(43, 1));
        map.put(class_1972.field_9408.method_29177(), new ColormapProperties.ColumnBounds(44, 1));
        map.put(class_1972.field_9441.method_29177(), new ColormapProperties.ColumnBounds(45, 1));
        map.put(class_1972.field_9467.method_29177(), new ColormapProperties.ColumnBounds(46, 1));
        map.put(class_1972.field_9439.method_29177(), new ColormapProperties.ColumnBounds(48, 1));
        map.put(class_1972.field_9470.method_29177(), new ColormapProperties.ColumnBounds(49, 1));
        map.put(class_1972.field_9418.method_29177(), new ColormapProperties.ColumnBounds(50, 1));
        map.put(class_1972.field_9473.method_29177(), new ColormapProperties.ColumnBounds(127, 1));
        map.put(class_1972.field_9455.method_29177(), new ColormapProperties.ColumnBounds(129, 1));
        map.put(class_1972.field_35111.method_29177(), new ColormapProperties.ColumnBounds(131, 1));
        map.put(class_1972.field_9414.method_29177(), new ColormapProperties.ColumnBounds(132, 1));
        map.put(class_1972.field_9453.method_29177(), new ColormapProperties.ColumnBounds(140, 1));
        map.put(class_1972.field_35112.method_29177(), new ColormapProperties.ColumnBounds(155, 1));
        map.put(class_1972.field_35113.method_29177(), new ColormapProperties.ColumnBounds(160, 1));
        map.put(class_1972.field_35114.method_29177(), new ColormapProperties.ColumnBounds(163, 1));
        map.put(class_1972.field_9443.method_29177(), new ColormapProperties.ColumnBounds(165, 1));
        map.put(class_1972.field_9440.method_29177(), new ColormapProperties.ColumnBounds(168, 1));
        map.put(class_1972.field_22076.method_29177(), new ColormapProperties.ColumnBounds(170, 1));
        map.put(class_1972.field_22077.method_29177(), new ColormapProperties.ColumnBounds(171, 1));
        map.put(class_1972.field_22075.method_29177(), new ColormapProperties.ColumnBounds(172, 1));
        map.put(class_1972.field_23859.method_29177(), new ColormapProperties.ColumnBounds(173, 1));
        map.put(class_1972.field_28107.method_29177(), new ColormapProperties.ColumnBounds(174, 1));
        map.put(class_1972.field_29218.method_29177(), new ColormapProperties.ColumnBounds(175, 1));
        map.put(class_1972.field_34470.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_34471.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_34472.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_35115.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_34474.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_34475.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        return map;
    }

    private static Map<class_2960, ColormapProperties.ColumnBounds> createStableColumnBounds() {
        HashMap<class_2960, ColormapProperties.ColumnBounds> map = new HashMap<class_2960, ColormapProperties.ColumnBounds>();
        map.put(class_1972.field_9473.method_29177(), new ColormapProperties.ColumnBounds(0, 1));
        map.put(class_1972.field_9451.method_29177(), new ColormapProperties.ColumnBounds(1, 1));
        map.put(class_1972.field_9455.method_29177(), new ColormapProperties.ColumnBounds(2, 1));
        map.put(class_1972.field_35117.method_29177(), new ColormapProperties.ColumnBounds(3, 1));
        map.put(class_1972.field_9453.method_29177(), new ColormapProperties.ColumnBounds(4, 1));
        map.put(class_1972.field_9424.method_29177(), new ColormapProperties.ColumnBounds(5, 1));
        map.put(class_1972.field_9471.method_29177(), new ColormapProperties.ColumnBounds(6, 1));
        map.put(class_1972.field_9409.method_29177(), new ColormapProperties.ColumnBounds(7, 1));
        map.put(class_1972.field_9414.method_29177(), new ColormapProperties.ColumnBounds(8, 1));
        map.put(class_1972.field_9412.method_29177(), new ColormapProperties.ColumnBounds(9, 1));
        map.put(class_1972.field_9475.method_29177(), new ColormapProperties.ColumnBounds(10, 1));
        map.put(class_1972.field_35112.method_29177(), new ColormapProperties.ColumnBounds(11, 1));
        map.put(class_1972.field_35119.method_29177(), new ColormapProperties.ColumnBounds(12, 1));
        map.put(class_1972.field_35113.method_29177(), new ColormapProperties.ColumnBounds(13, 1));
        map.put(class_1972.field_9420.method_29177(), new ColormapProperties.ColumnBounds(14, 1));
        map.put(class_1972.field_9454.method_29177(), new ColormapProperties.ColumnBounds(15, 1));
        map.put(class_1972.field_9449.method_29177(), new ColormapProperties.ColumnBounds(16, 1));
        map.put(class_1972.field_9430.method_29177(), new ColormapProperties.ColumnBounds(17, 1));
        map.put(class_1972.field_35116.method_29177(), new ColormapProperties.ColumnBounds(18, 1));
        map.put(class_1972.field_35111.method_29177(), new ColormapProperties.ColumnBounds(19, 1));
        map.put(class_1972.field_35120.method_29177(), new ColormapProperties.ColumnBounds(20, 1));
        map.put(class_1972.field_35114.method_29177(), new ColormapProperties.ColumnBounds(21, 1));
        map.put(class_1972.field_9417.method_29177(), new ColormapProperties.ColumnBounds(22, 1));
        map.put(class_1972.field_35118.method_29177(), new ColormapProperties.ColumnBounds(23, 1));
        map.put(class_1972.field_9440.method_29177(), new ColormapProperties.ColumnBounds(24, 1));
        map.put(class_1972.field_9415.method_29177(), new ColormapProperties.ColumnBounds(25, 1));
        map.put(class_1972.field_9443.method_29177(), new ColormapProperties.ColumnBounds(26, 1));
        map.put(class_1972.field_35110.method_29177(), new ColormapProperties.ColumnBounds(27, 1));
        map.put(class_1972.field_34470.method_29177(), new ColormapProperties.ColumnBounds(28, 1));
        map.put(class_1972.field_34471.method_29177(), new ColormapProperties.ColumnBounds(29, 1));
        map.put(class_1972.field_34472.method_29177(), new ColormapProperties.ColumnBounds(30, 1));
        map.put(class_1972.field_35115.method_29177(), new ColormapProperties.ColumnBounds(31, 1));
        map.put(class_1972.field_34474.method_29177(), new ColormapProperties.ColumnBounds(32, 1));
        map.put(class_1972.field_34475.method_29177(), new ColormapProperties.ColumnBounds(33, 1));
        map.put(class_1972.field_9438.method_29177(), new ColormapProperties.ColumnBounds(34, 1));
        map.put(class_1972.field_9463.method_29177(), new ColormapProperties.ColumnBounds(35, 1));
        map.put(class_1972.field_9434.method_29177(), new ColormapProperties.ColumnBounds(36, 1));
        map.put(class_1972.field_9478.method_29177(), new ColormapProperties.ColumnBounds(37, 1));
        map.put(class_1972.field_9419.method_29177(), new ColormapProperties.ColumnBounds(38, 1));
        map.put(class_1972.field_9408.method_29177(), new ColormapProperties.ColumnBounds(39, 1));
        map.put(class_1972.field_9441.method_29177(), new ColormapProperties.ColumnBounds(40, 1));
        map.put(class_1972.field_9439.method_29177(), new ColormapProperties.ColumnBounds(41, 1));
        map.put(class_1972.field_9423.method_29177(), new ColormapProperties.ColumnBounds(42, 1));
        map.put(class_1972.field_9446.method_29177(), new ColormapProperties.ColumnBounds(43, 1));
        map.put(class_1972.field_9467.method_29177(), new ColormapProperties.ColumnBounds(44, 1));
        map.put(class_1972.field_9470.method_29177(), new ColormapProperties.ColumnBounds(45, 1));
        map.put(class_1972.field_9435.method_29177(), new ColormapProperties.ColumnBounds(46, 1));
        map.put(class_1972.field_9418.method_29177(), new ColormapProperties.ColumnBounds(47, 1));
        map.put(class_1972.field_9462.method_29177(), new ColormapProperties.ColumnBounds(48, 1));
        map.put(class_1972.field_28107.method_29177(), new ColormapProperties.ColumnBounds(49, 1));
        map.put(class_1972.field_29218.method_29177(), new ColormapProperties.ColumnBounds(50, 1));
        map.put(class_1972.field_9461.method_29177(), new ColormapProperties.ColumnBounds(51, 1));
        map.put(class_1972.field_22075.method_29177(), new ColormapProperties.ColumnBounds(52, 1));
        map.put(class_1972.field_22077.method_29177(), new ColormapProperties.ColumnBounds(53, 1));
        map.put(class_1972.field_22076.method_29177(), new ColormapProperties.ColumnBounds(54, 1));
        map.put(class_1972.field_23859.method_29177(), new ColormapProperties.ColumnBounds(55, 1));
        map.put(class_1972.field_9411.method_29177(), new ColormapProperties.ColumnBounds(56, 1));
        map.put(class_1972.field_9442.method_29177(), new ColormapProperties.ColumnBounds(57, 1));
        map.put(class_1972.field_9447.method_29177(), new ColormapProperties.ColumnBounds(58, 1));
        map.put(class_1972.field_9457.method_29177(), new ColormapProperties.ColumnBounds(59, 1));
        map.put(class_1972.field_9465.method_29177(), new ColormapProperties.ColumnBounds(60, 1));
        return map;
    }
}

