/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.properties;

import com.google.gson.JsonSyntaxException;
import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.properties.ApplicableBlockStates;
import io.github.kvverti.colormatic.properties.BiomeRenaming;
import io.github.kvverti.colormatic.properties.DefaultColumns;
import io.github.kvverti.colormatic.properties.GridEntry;
import io.github.kvverti.colormatic.properties.HexColor;
import io.github.kvverti.colormatic.properties.PropertyUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ColormapProperties {
    private static final Logger log = LogManager.getLogger();
    private final class_2960 id;
    private final transient boolean optifine;
    private final Format format;
    private final Collection<ApplicableBlockStates> blocks;
    private final class_2960 source;
    private final HexColor color;
    private final ColumnLayout layout;
    private final int yVariance;
    private final int yOffset;
    private final Map<class_2960, ColumnBounds> columnsByBiome;
    private static final ColumnBounds DEFAULT_BOUNDS = new ColumnBounds(0, 1);

    private ColormapProperties(class_2960 id, Settings settings) {
        this.id = id;
        this.optifine = this.id.method_12832().endsWith(".properties");
        this.format = settings.format;
        this.blocks = settings.blocks;
        class_2960 source = class_2960.method_12829((String)settings.source);
        if (source == null) {
            log.error("{}: Invalid source location '{}', using file name as fallback", (Object)id, (Object)settings.source);
            source = new class_2960(ColormapProperties.makeSourceFromFileName(id));
        }
        this.source = source;
        this.color = settings.color;
        this.layout = Objects.requireNonNullElse(settings.layout, this.optifine ? ColumnLayout.OPTIFINE : ColumnLayout.DEFAULT);
        this.yVariance = settings.yVariance;
        this.yOffset = settings.yOffset;
        if (settings.grid != null) {
            this.columnsByBiome = new HashMap<class_2960, ColumnBounds>();
            int nextColumn = 0;
            for (GridEntry entry : settings.grid) {
                if (entry.column >= 0) {
                    nextColumn = entry.column;
                }
                ColumnBounds bounds = new ColumnBounds(nextColumn, entry.width);
                nextColumn += entry.width;
                for (class_2960 biomeId : entry.biomes) {
                    class_2960 updated = BiomeRenaming.updateName(biomeId, this.id);
                    if (updated == null) continue;
                    this.columnsByBiome.put(updated, bounds);
                }
            }
        } else if (settings.biomes != null) {
            this.columnsByBiome = new HashMap<class_2960, ColumnBounds>();
            for (Map.Entry<class_2960, Integer> entry : settings.biomes.entrySet()) {
                class_2960 updated = BiomeRenaming.updateName(entry.getKey(), this.id);
                if (updated == null) continue;
                this.columnsByBiome.put(updated, new ColumnBounds(entry.getValue(), 1));
            }
        } else {
            this.columnsByBiome = null;
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public Format getFormat() {
        return this.format;
    }

    public HexColor getColor() {
        return this.color;
    }

    public class_2960 getSource() {
        return this.source;
    }

    public int getVariance() {
        return this.yVariance;
    }

    public int getOffset() {
        return this.yOffset;
    }

    public ColumnBounds getColumn(class_5321<class_1959> biomeKey, class_2378<class_1959> biomeRegistry) {
        if (this.format == Format.GRID) {
            if (biomeKey != null) {
                class_2960 id = biomeKey.method_29177();
                if (this.columnsByBiome != null) {
                    ColumnBounds cb = this.columnsByBiome.get(id);
                    if (cb == null) {
                        throw new IllegalArgumentException(id.toString());
                    }
                    return cb;
                }
                return switch (this.layout) {
                    default -> throw new IncompatibleClassChangeError();
                    case ColumnLayout.DEFAULT -> DefaultColumns.getDefaultBounds(biomeKey);
                    case ColumnLayout.OPTIFINE -> DefaultColumns.getOptifineBounds(biomeKey, biomeRegistry);
                    case ColumnLayout.LEGACY -> DefaultColumns.getLegacyBounds(biomeKey, biomeRegistry, this.optifine);
                    case ColumnLayout.STABLE -> DefaultColumns.getStableBounds(biomeKey);
                };
            }
            return DEFAULT_BOUNDS;
        }
        throw new IllegalStateException(this.format.toString());
    }

    public Set<class_2960> getApplicableBiomes() {
        HashSet<class_2960> res = new HashSet<class_2960>();
        if (this.columnsByBiome != null) {
            res.addAll(this.columnsByBiome.keySet());
        }
        return res;
    }

    public Set<class_2248> getApplicableBlocks() {
        HashSet<class_2248> res = new HashSet<class_2248>();
        for (ApplicableBlockStates a : this.blocks) {
            if (a.specialKey != null || !a.states.isEmpty()) continue;
            res.add(a.block);
        }
        return res;
    }

    public Set<class_2680> getApplicableBlockStates() {
        HashSet<class_2680> res = new HashSet<class_2680>();
        for (ApplicableBlockStates a : this.blocks) {
            if (a.specialKey != null) continue;
            res.addAll(a.states);
        }
        return res;
    }

    public Map<class_2960, Collection<class_2960>> getApplicableSpecialIds() {
        HashMap<class_2960, Collection<class_2960>> res = new HashMap<class_2960, Collection<class_2960>>();
        for (ApplicableBlockStates a : this.blocks) {
            if (a.specialKey == null) continue;
            res.put(a.specialKey, a.specialIds);
        }
        return res;
    }

    public String toString() {
        return String.format("ColormapProperties { format=%s, blocks=%s, source=%s, color=%x, yVariance=%x, yOffset=%x }", new Object[]{this.format, this.blocks, this.source, this.color == null ? 0 : this.color.rgb(), this.yVariance, this.yOffset});
    }

    /*
     * Exception decompiling
     */
    public static ColormapProperties load(class_3300 manager, class_2960 id, boolean custom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ColormapProperties loadFromJson(Reader json, class_2960 id, boolean custom) {
        Settings settings;
        try {
            settings = (Settings)PropertyUtil.PROPERTY_GSON.fromJson(json, Settings.class);
            if (settings == null) {
                settings = new Settings();
            }
        }
        catch (Exception e) {
            log.error("Error loading {}: {}", (Object)id, (Object)e.getMessage());
            settings = new Settings();
        }
        if (settings.format == null) {
            settings.format = Colormatic.COLOR_PROPS.getProperties().getDefaultFormat();
        }
        if (settings.layout == null) {
            settings.layout = Colormatic.COLOR_PROPS.getProperties().getDefaultLayout();
        }
        if (custom) {
            if (settings.blocks == null) {
                String blockId = id.method_12832();
                blockId = blockId.substring(blockId.lastIndexOf(47) + 1, blockId.lastIndexOf(46));
                settings.blocks = new ArrayList<ApplicableBlockStates>();
                try {
                    settings.blocks.add((ApplicableBlockStates)PropertyUtil.PROPERTY_GSON.fromJson(blockId, ApplicableBlockStates.class));
                }
                catch (JsonSyntaxException e) {
                    log.error("Error parsing {}: {}", (Object)id, (Object)e.getMessage());
                }
            }
        } else {
            if (settings.biomes != null || settings.grid != null || settings.blocks != null) {
                log.warn("{}: found `biomes`, `grid`, or `blocks` properties in a provided colormap; these will be ignored", (Object)id);
            }
            settings.biomes = null;
            settings.grid = null;
            settings.blocks = Collections.emptyList();
        }
        if (settings.source == null) {
            settings.source = ColormapProperties.makeSourceFromFileName(id);
        }
        settings.source = PropertyUtil.resolve(settings.source, id);
        return new ColormapProperties(id, settings);
    }

    private static String makeSourceFromFileName(class_2960 id) {
        Object path = id.toString();
        path = ((String)path).substring(0, ((String)path).lastIndexOf(46)) + ".png";
        return path;
    }

    private static /* synthetic */ String lambda$load$0(String k) {
        return k;
    }

    private static class Settings {
        Format format = null;
        Collection<ApplicableBlockStates> blocks = null;
        String source = null;
        HexColor color = null;
        ColumnLayout layout = null;
        int yVariance = 0;
        int yOffset = 0;
        Map<class_2960, Integer> biomes = null;
        List<GridEntry> grid = null;

        private Settings() {
        }
    }

    public static enum Format implements class_3542
    {
        FIXED("fixed"),
        VANILLA("vanilla"),
        GRID("grid");

        private final String name;

        private Format(String s) {
            this.name = s;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static enum ColumnLayout implements class_3542
    {
        DEFAULT("default"),
        OPTIFINE("optifine"),
        LEGACY("legacy"),
        STABLE("stable");

        private final String name;

        private ColumnLayout(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class ColumnBounds {
        public final int column;
        public final int count;

        public ColumnBounds(int c, int n) {
            this.column = c;
            this.count = n;
        }
    }
}

