/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.mixin.render;

import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.ColormaticConfig;
import io.github.kvverti.colormatic.Lightmaps;
import io.github.kvverti.colormatic.colormap.Lightmap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_765.class})
public abstract class LightmapTextureManagerMixin {
    @Shadow
    @Final
    private class_1043 field_4138;
    @Shadow
    @Final
    private class_1011 field_4133;
    @Shadow
    private float field_21528;
    @Shadow
    @Final
    private class_310 field_4137;
    @Unique
    private float flickerTarget;
    @Unique
    private float flickerPos;
    @Unique
    private int flickerTicksRemaining;
    @Unique
    private double relativeIntensityExpScale;
    @Unique
    private int lightIndex = 0;
    @Unique
    private final int[] SKY_LIGHT_COLORS = new int[16];
    @Unique
    private final int[] BLOCK_LIGHT_COLORS = new int[16];

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTickTickFlicker(CallbackInfo info) {
        if (Colormatic.config().flickerBlockLight) {
            if (this.flickerTicksRemaining == 0) {
                this.flickerTicksRemaining = 4;
                this.flickerTarget = (float)Math.random();
            }
            this.flickerPos = class_3532.method_16439((float)(1.0f / (float)this.flickerTicksRemaining), (float)this.flickerPos, (float)this.flickerTarget);
            --this.flickerTicksRemaining;
        } else {
            this.flickerPos = 0.0f;
            this.field_21528 = 0.0f;
        }
    }

    @Inject(method={"update"}, at={@At(value="JUMP", ordinal=1, shift=At.Shift.BEFORE)}, cancellable=true)
    private void onUpdate(float partialTicks, CallbackInfo info) {
        Lightmap map;
        class_638 world = this.field_4137.field_1687;
        if (world == null) {
            return;
        }
        float ambience = (world.method_23783(partialTicks) - 0.2f) * 1.25f;
        this.relativeIntensityExpScale = (double)ambience * ColormaticConfig.scaled(Colormatic.config().relativeBlockLightIntensityExponent) / 16.0;
        if (world.method_23789() > 0) {
            ambience = -1.0f;
        }
        if ((map = Lightmaps.get((class_1937)world)) != null) {
            class_746 player = this.field_4137.field_1724;
            float nightVision = player.method_5869() && player.method_6059(class_1294.field_5927) ? 1.0f : (player.method_6059(class_1294.field_5925) ? class_757.method_3174((class_1309)player, (float)partialTicks) : 0.0f);
            for (int i = 0; i < 16; ++i) {
                this.SKY_LIGHT_COLORS[i] = map.getSkyLight(i, ambience, nightVision);
                this.BLOCK_LIGHT_COLORS[i] = map.getBlockLight(i, this.flickerPos, nightVision);
            }
            for (int skyLight = 0; skyLight < 16; ++skyLight) {
                float blockIntensityScale = (float)Math.exp(this.relativeIntensityExpScale * (double)skyLight);
                for (int blockLight = 0; blockLight < 16; ++blockLight) {
                    int skyColor = this.SKY_LIGHT_COLORS[skyLight];
                    int blockColor = this.BLOCK_LIGHT_COLORS[blockLight];
                    float scale = blockLight == 15 ? 1.0f : blockIntensityScale;
                    float r = Math.min(255.0f, (float)((skyColor & 0xFF0000) >> 16) + scale * (float)((blockColor & 0xFF0000) >> 16)) / 255.0f;
                    float g = Math.min(255.0f, (float)((skyColor & 0xFF00) >> 8) + scale * (float)((blockColor & 0xFF00) >> 8)) / 255.0f;
                    float b = Math.min(255.0f, (float)(skyColor & 0xFF) + scale * (float)(blockColor & 0xFF)) / 255.0f;
                    float rbright = 1.0f - r;
                    float gbright = 1.0f - g;
                    float bbright = 1.0f - b;
                    rbright *= rbright;
                    gbright *= gbright;
                    bbright *= bbright;
                    rbright *= rbright;
                    gbright *= gbright;
                    bbright *= bbright;
                    rbright = 1.0f - rbright;
                    gbright = 1.0f - gbright;
                    bbright = 1.0f - bbright;
                    float brightness = (float)this.field_4137.field_1690.field_1840;
                    r = r * (1.0f - brightness) + rbright * brightness;
                    g = g * (1.0f - brightness) + gbright * brightness;
                    b = b * (1.0f - brightness) + bbright * brightness;
                    int color = -16777216;
                    color |= (int)(r * 255.0f) << 16;
                    color |= (int)(g * 255.0f) << 8;
                    this.field_4133.method_4305(blockLight, skyLight, color |= (int)(b * 255.0f));
                }
            }
            this.field_4138.method_4524();
            this.field_4137.method_16011().method_15407();
            info.cancel();
        }
    }

    @ModifyVariable(method={"update"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    private float modifySkyAmbience(float ambience) {
        if (!Colormatic.config().blendSkyLight) {
            ambience = (float)((int)(ambience * 16.0f)) / 16.0f;
        }
        return ambience;
    }

    @ModifyVariable(method={"update"}, at=@At(value="STORE", ordinal=0), index=13)
    private float modifyFlickerIntensity(float blockLight) {
        int sky = this.lightIndex >>> 4;
        int block = this.lightIndex & 0xF;
        this.lightIndex = this.lightIndex + 1 & 0xFF;
        if (block != 15) {
            return blockLight * (float)Math.exp(this.relativeIntensityExpScale * (double)sky);
        }
        return blockLight;
    }
}

