/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.mixin.render;

import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.colormap.BiomeColormap;
import io.github.kvverti.colormatic.colormap.BiomeColormaps;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import io.github.kvverti.colormatic.resource.BiomeColormapResource;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4184;
import net.minecraft.class_4543;
import net.minecraft.class_5636;
import net.minecraft.class_5742;
import net.minecraft.class_638;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_758.class})
public abstract class BackgroundRendererMixin {
    @Shadow
    private static float field_4034;
    @Shadow
    private static float field_4033;
    @Shadow
    private static float field_4032;
    @Unique
    private static float redStore;
    @Unique
    private static float greenStore;
    @Unique
    private static float blueStore;

    @ModifyVariable(method={"render"}, at=@At(value="LOAD", ordinal=0), ordinal=0)
    private static class_5636 detectShouldColormaticFluidBlend(class_5636 submersionType) {
        if (submersionType == class_5636.field_27885 && (BiomeColormaps.isFluidFogCustomColored((class_3611)class_3612.field_15908) || Colormatic.UNDERLAVA_COLORS.hasCustomColormap())) {
            return class_5636.field_27886;
        }
        return submersionType;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getWaterFogColor()I"))
    private static int proxyWaterLavaFogColor(class_1959 biome, class_4184 camera, float tickDelta, class_638 world, int i, float f) {
        BiomeColormap colormap;
        BiomeColormapResource colormapResource;
        class_3609 fluid;
        class_5636 submersionType = camera.method_19334();
        if (submersionType == class_5636.field_27885) {
            fluid = class_3612.field_15908;
            colormapResource = Colormatic.UNDERLAVA_COLORS;
        } else {
            fluid = class_3612.field_15910;
            colormapResource = Colormatic.UNDERWATER_COLORS;
        }
        int color = 0;
        if (BiomeColormaps.isFluidFogCustomColored((class_3611)fluid) && (colormap = BiomeColormaps.getFluidFog(world.method_30349(), (class_3611)fluid, biome)) != null) {
            class_2338 pos = camera.method_19328();
            color = colormap.getColor(world.method_30349(), biome, pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        if (color == 0) {
            if (colormapResource.hasCustomColormap()) {
                class_2338 pos = camera.method_19328();
                color = colormapResource.getColormap().getColor(world.method_30349(), biome, pos.method_10263(), pos.method_10264(), pos.method_10260());
            } else {
                color = submersionType == class_5636.field_27885 ? 0x991900 : biome.method_8713();
            }
        }
        return color;
    }

    @Redirect(method={"method_24873"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getFogColor()I"))
    @Dynamic(value="RgbFetcher lambda method in #render")
    private static int proxyCustomFogColor(class_1959 self, class_638 world, class_4543 access, float angleDelta, int x, int y, int z) {
        if (Colormatic.config().clearSky && world.method_8597().method_12491()) {
            return self.method_24376();
        }
        class_2960 dimId = Colormatic.getDimId((class_1937)world);
        ColormaticResolver resolver = BiomeColormaps.getTotalSkyFog(dimId);
        return resolver.getColor(world.method_30349(), self, class_5742.method_33101((int)x), class_5742.method_33101((int)y), class_5742.method_33101((int)z));
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/BackgroundRenderer;blue:F", opcode=179, ordinal=0, shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/CubicSampler;sampleColor(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/CubicSampler$RgbFetcher;)Lnet/minecraft/util/math/Vec3d;"))})
    private static void setFogColorToSkyColor(class_4184 camera, float partialTicks, class_638 world, int i, float f, CallbackInfo info) {
        if (Colormatic.config().clearSky && world.method_8597().method_12491()) {
            class_243 color = world.method_23777(camera.method_19326(), partialTicks);
            field_4034 = (float)color.field_1352;
            field_4033 = (float)color.field_1351;
            field_4032 = (float)color.field_1350;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainGradient(F)F")})
    private static void saveColorsToRestRainAndThunder(CallbackInfo info) {
        if (Colormatic.config().clearSky) {
            redStore = field_4034;
            greenStore = field_4033;
            blueStore = field_4032;
        }
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lnet/minecraft/client/render/BackgroundRenderer;lastWaterFogColorUpdateTime:J")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainGradient(F)F"))})
    private static void resetRainAndThunderColors(CallbackInfo info) {
        if (Colormatic.config().clearSky) {
            field_4034 = redStore;
            field_4033 = greenStore;
            field_4032 = blueStore;
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE", ordinal=2), index=7)
    private static float modifyVoidColor(float scale) {
        if (Colormatic.config().clearVoid) {
            scale = 1.0f;
        }
        return scale;
    }
}

