/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import io.github.kvverti.colormatic.Colormatic;
import net.minecraft.class_1011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Lightmap {
    private static final Logger log = LogManager.getLogger();
    private final class_1011 lightmap;

    public Lightmap(class_1011 lightmap) {
        this.lightmap = lightmap;
    }

    @Deprecated
    public boolean hasCustomColormap() {
        return this.lightmap != null;
    }

    public int getBlockLight(int level, float flicker, float nightVision) {
        int width = this.lightmap.method_4307();
        int posX = (int)(flicker * (float)width) % width;
        if (posX < 0) {
            posX = -posX;
        }
        return this.getPixel(posX, level + 16, nightVision);
    }

    public int getSkyLight(int level, float ambience, float nightVision) {
        if (ambience < 0.0f) {
            int posX = this.lightmap.method_4307() - 1;
            return this.getPixel(posX, level, nightVision);
        }
        float scaledAmbience = ambience * (float)(this.lightmap.method_4307() - 2);
        float scaledAmbienceRemainder = scaledAmbience % 1.0f;
        int posX = (int)scaledAmbience;
        int light = this.getPixel(posX, level, nightVision);
        boolean blend = Colormatic.config().blendSkyLight;
        if (blend && posX < this.lightmap.method_4307() - 2) {
            int rightLight = this.getPixel(posX + 1, level, nightVision);
            light = this.mergeColors(rightLight, light, scaledAmbienceRemainder);
        }
        return light;
    }

    private int getPixel(int x, int y, float nightVision) {
        if (nightVision > 0.0f) {
            int nightVisionColor;
            if (this.lightmap.method_4323() != 64) {
                int color = this.lightmap.method_4315(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color >> 0 & 0xFF;
                int scale = Math.max(Math.max(r, g), b);
                int ret = -16777216;
                if (scale != 0) {
                    ret |= 255 * r / scale << 16;
                    ret |= 255 * g / scale << 8;
                    ret |= 255 * b / scale << 0;
                } else {
                    ret |= 0xFFFFFF;
                }
                nightVisionColor = ret;
            } else {
                nightVisionColor = this.lightmap.method_4315(x, y + 32);
            }
            if (nightVision >= 1.0f) {
                return nightVisionColor;
            }
            int normalColor = this.lightmap.method_4315(x, y);
            return this.mergeColors(normalColor, nightVisionColor, nightVision);
        }
        return this.lightmap.method_4315(x, y);
    }

    private int mergeColors(int a, int b, float aweight) {
        float oneMinusAweight = 1.0f - aweight;
        int res = -16777216;
        int cha = a >> 16 & 0xFF;
        int chb = b >> 16 & 0xFF;
        res |= (int)((float)cha * aweight + (float)chb * oneMinusAweight) << 16;
        cha = a >> 8 & 0xFF;
        chb = b >> 8 & 0xFF;
        res |= (int)((float)cha * aweight + (float)chb * oneMinusAweight) << 8;
        cha = a & 0xFF;
        chb = b & 0xFF;
        return res |= (int)((float)cha * aweight + (float)chb * oneMinusAweight);
    }
}

