/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import io.github.kvverti.colormatic.colormap.ColormaticResolverProvider;
import io.github.kvverti.colormatic.mixin.color.BlockColorsAccessor;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3611;
import net.minecraft.class_638;

final class DefaultColormaticResolverProviders {
    public static final ColormaticResolverProvider<class_2680> BLOCK_STATE = DefaultColormaticResolverProviders::byBlockState;
    public static final ColormaticResolverProvider<class_2248> BLOCK = DefaultColormaticResolverProviders::byBlock;
    public static final ColormaticResolverProvider<class_2960> SKY = DefaultColormaticResolverProviders::bySky;
    public static final ColormaticResolverProvider<class_2960> SKY_FOG = DefaultColormaticResolverProviders::byFog;
    public static final ColormaticResolverProvider<class_3611> FLUID_FOG = key -> (manager, biome, posX, posY, posZ) -> -1;

    private DefaultColormaticResolverProviders() {
    }

    private static ColormaticResolver byBlockState(class_2680 key) {
        return (manager, biome, posX, posY, posZ) -> {
            class_322 colorProvider = (class_322)((BlockColorsAccessor)class_310.method_1551().method_1505()).getProviders().method_10200(class_2378.field_11146.method_10206((Object)key.method_26204()));
            if (colorProvider != null) {
                class_638 world = class_310.method_1551().field_1687;
                return colorProvider.getColor(key, (class_1920)world, new class_2338(posX, posY, posZ), 0);
            }
            return -1;
        };
    }

    private static ColormaticResolver byBlock(class_2248 key) {
        return DefaultColormaticResolverProviders.byBlockState(key.method_9564());
    }

    private static ColormaticResolver bySky(class_2960 key) {
        return (manager, biome, posX, posY, posZ) -> {
            int color;
            if (Colormatic.SKY_COLORS.hasCustomColormap() && key.equals((Object)class_2874.field_26752)) {
                color = Colormatic.SKY_COLORS.getColormap().getColor(manager, biome, posX, posY, posZ);
            } else {
                color = Colormatic.COLOR_PROPS.getProperties().getDimensionSky(key);
                if (color == 0) {
                    color = biome.method_8697();
                }
            }
            return color;
        };
    }

    private static ColormaticResolver byFog(class_2960 key) {
        return (manager, biome, posX, posY, posZ) -> {
            int color;
            if (Colormatic.FOG_COLORS.hasCustomColormap() && key.equals((Object)class_2874.field_26752)) {
                color = 0xFF000000 | Colormatic.FOG_COLORS.getColormap().getColor(manager, biome, posX, posY, posZ);
            } else {
                color = Colormatic.COLOR_PROPS.getProperties().getDimensionFog(key);
                if (color == 0) {
                    color = biome.method_24376();
                }
            }
            return color;
        };
    }
}

