/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.github.kvverti.colormatic.Colormatic;
import io.github.kvverti.colormatic.colormap.BiomeColormap;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import io.github.kvverti.colormatic.colormap.ColormaticResolverProvider;
import io.github.kvverti.colormatic.colormap.ExtendedColorResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

final class ColormapStorage<K> {
    private final Table<K, class_2960, BiomeColormap> colormaps = HashBasedTable.create();
    private final Map<K, BiomeColormap> fallbackColormaps = new HashMap<K, BiomeColormap>();
    private final Map<K, ExtendedColorResolver> resolvers = new HashMap<K, ExtendedColorResolver>();
    private final Map<K, ColormaticResolver> defaultResolvers = new HashMap<K, ColormaticResolver>();
    private final ColormaticResolverProvider<K> defaultResolverProvider;

    ColormapStorage(ColormaticResolverProvider<K> defaultResolverProvider) {
        this.defaultResolverProvider = defaultResolverProvider;
    }

    @Nullable
    public BiomeColormap get(class_5455 manager, K key, class_1959 biome) {
        BiomeColormap res = (BiomeColormap)this.colormaps.get(key, (Object)Colormatic.getBiomeId(manager, biome));
        if (res == null) {
            res = this.fallbackColormaps.get(key);
        }
        return res;
    }

    @Nullable
    public BiomeColormap getFallback(K key) {
        return this.fallbackColormaps.get(key);
    }

    @Nullable
    public ExtendedColorResolver getResolver(K key) {
        return this.resolvers.get(key);
    }

    public ColormaticResolver getColormaticResolver(K key) {
        ExtendedColorResolver extendedResolver = this.getResolver(key);
        if (extendedResolver != null) {
            return extendedResolver.getWrappedResolver();
        }
        return this.defaultResolvers.computeIfAbsent(key, this.defaultResolverProvider::create);
    }

    public boolean contains(K key) {
        return !this.colormaps.row(key).isEmpty() || this.fallbackColormaps.containsKey(key);
    }

    public void addColormap(BiomeColormap colormap, Collection<? extends K> keys, Set<? extends class_2960> biomes) {
        if (biomes.isEmpty()) {
            for (K key : keys) {
                this.fallbackColormaps.put(key, colormap);
                this.resolvers.put(key, new ExtendedColorResolver(this, key, this.defaultResolvers.computeIfAbsent(key, this.defaultResolverProvider::create)));
            }
        } else {
            for (K key : keys) {
                for (class_2960 class_29602 : biomes) {
                    this.colormaps.put(key, (Object)class_29602, (Object)colormap);
                }
                this.resolvers.put(key, new ExtendedColorResolver(this, key, this.defaultResolvers.computeIfAbsent(key, this.defaultResolverProvider::create)));
            }
        }
    }

    public void clear() {
        this.colormaps.clear();
        this.fallbackColormaps.clear();
        this.resolvers.clear();
        this.defaultResolvers.clear();
    }
}

