/*
 * Decompiled with CFR 0.152.
 */
package io.github.kvverti.colormatic.colormap;

import io.github.kvverti.colormatic.colormap.BiomeColormap;
import io.github.kvverti.colormatic.colormap.ColormapStorage;
import io.github.kvverti.colormatic.colormap.ColormaticResolver;
import io.github.kvverti.colormatic.colormap.DefaultColormaticResolverProviders;
import io.github.kvverti.colormatic.colormap.ExtendedColorResolver;
import io.github.kvverti.colormatic.properties.ColormapProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1920;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5455;

public final class BiomeColormaps {
    private static final ColormapStorage<class_2248> colormapsByBlock = new ColormapStorage<class_2248>(DefaultColormaticResolverProviders.BLOCK);
    private static final ColormapStorage<class_2680> colormapsByState = new ColormapStorage<class_2680>(DefaultColormaticResolverProviders.BLOCK_STATE);
    private static final ColormapStorage<class_2960> skyColormaps = new ColormapStorage<class_2960>(DefaultColormaticResolverProviders.SKY);
    private static final ColormapStorage<class_2960> skyFogColormaps = new ColormapStorage<class_2960>(DefaultColormaticResolverProviders.SKY_FOG);
    private static final ColormapStorage<class_3611> fluidFogColormaps = new ColormapStorage<class_3611>(DefaultColormaticResolverProviders.FLUID_FOG);

    private BiomeColormaps() {
    }

    public static ColormaticResolver getTotalSky(class_2960 dimId) {
        return skyColormaps.getColormaticResolver(dimId);
    }

    public static ColormaticResolver getTotalSkyFog(class_2960 dimId) {
        return skyFogColormaps.getColormaticResolver(dimId);
    }

    public static BiomeColormap getFluidFog(class_5455 manager, class_3611 fluid, class_1959 biome) {
        return fluidFogColormaps.get(manager, fluid, biome);
    }

    public static void add(BiomeColormap colormap) {
        ColormapProperties props = colormap.getProperties();
        Set<class_2960> biomes = props.getApplicableBiomes();
        colormapsByState.addColormap(colormap, props.getApplicableBlockStates(), biomes);
        colormapsByBlock.addColormap(colormap, props.getApplicableBlocks(), biomes);
        for (Map.Entry<class_2960, Collection<class_2960>> entry : props.getApplicableSpecialIds().entrySet()) {
            switch (entry.getKey().toString()) {
                case "colormatic:sky": {
                    skyColormaps.addColormap(colormap, entry.getValue(), biomes);
                    break;
                }
                case "colormatic:sky_fog": {
                    skyFogColormaps.addColormap(colormap, entry.getValue(), biomes);
                    break;
                }
                case "colormatic:fluid_fog": {
                    Collection fluids = entry.getValue().stream().map(arg_0 -> ((class_2348)class_2378.field_11154).method_10223(arg_0)).collect(Collectors.toList());
                    fluidFogColormaps.addColormap(colormap, fluids, biomes);
                }
            }
        }
    }

    public static void reset() {
        colormapsByBlock.clear();
        colormapsByState.clear();
        skyColormaps.clear();
        skyFogColormaps.clear();
        fluidFogColormaps.clear();
    }

    public static boolean isCustomColored(class_2680 state) {
        return colormapsByBlock.contains(state.method_26204()) || colormapsByState.contains(state);
    }

    public static boolean isItemCustomColored(class_2680 state) {
        return colormapsByBlock.getFallback(state.method_26204()) != null || colormapsByState.getFallback(state) != null;
    }

    public static boolean isFluidFogCustomColored(class_3611 fluid) {
        return fluidFogColormaps.contains(fluid);
    }

    public static int getBiomeColor(class_2680 state, class_1920 world, class_2338 pos) {
        if (world != null && pos != null) {
            ExtendedColorResolver resolver = colormapsByState.getResolver(state);
            if (resolver == null) {
                resolver = colormapsByBlock.getResolver(state.method_26204());
            }
            if (resolver == null) {
                throw new IllegalArgumentException(String.valueOf(state));
            }
            return resolver.resolveExtendedColor(world, pos);
        }
        BiomeColormap colormap = colormapsByState.getFallback(state);
        if (colormap == null) {
            colormap = colormapsByBlock.getFallback(state.method_26204());
        }
        if (colormap != null) {
            return colormap.getDefaultColor();
        }
        return 0xFFFFFF;
    }
}

