/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.skyboxes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.util.object.Conditions;
import io.github.amerebagatelle.fabricskyboxes.util.object.Decorations;
import io.github.amerebagatelle.fabricskyboxes.util.object.Properties;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5539;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;

public class OverworldSkybox
extends AbstractSkybox {
    public static Codec<OverworldSkybox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Properties.CODEC.fieldOf("properties").forGetter(AbstractSkybox::getProperties), (App)Conditions.CODEC.optionalFieldOf("conditions", (Object)Conditions.DEFAULT).forGetter(AbstractSkybox::getConditions), (App)Decorations.CODEC.optionalFieldOf("decorations", (Object)Decorations.DEFAULT).forGetter(AbstractSkybox::getDecorations)).apply((Applicative)instance, OverworldSkybox::new));

    public OverworldSkybox(Properties properties, Conditions conditions, Decorations decorations) {
        super(properties, conditions, decorations);
    }

    @Override
    public SkyboxType<? extends AbstractSkybox> getType() {
        return SkyboxType.MONO_COLOR_SKYBOX;
    }

    @Override
    public void render(WorldRendererAccess worldRendererAccess, class_4587 matrices, class_1159 projectionMatrix, float tickDelta, class_4184 camera, boolean thickFog) {
        float[] fs;
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        assert (client.field_1687 != null);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        class_243 vec3d = world.method_23777(client.field_1773.method_19418().method_19326(), tickDelta);
        float f = (float)vec3d.field_1352;
        float g = (float)vec3d.field_1351;
        float h = (float)vec3d.field_1350;
        RenderSystem.disableTexture();
        class_758.method_3212();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)this.alpha);
        class_5944 shaderProgram = RenderSystem.getShader();
        worldRendererAccess.getLightSkyBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
        class_291.method_1354();
        RenderSystem.enableBlend();
        float skyAngle = world.method_30274(tickDelta);
        float skyAngleRadian = world.method_8442(tickDelta);
        if (SkyboxManager.getInstance().isEnabled() && SkyboxManager.getInstance().getActiveSkyboxes().stream().anyMatch(skybox -> {
            AbstractSkybox abstractSkybox;
            return skybox instanceof AbstractSkybox && (abstractSkybox = (AbstractSkybox)skybox).getDecorations().getRotation().getSkyboxRotation();
        })) {
            skyAngle = class_3532.method_15341((float)((float)world.method_8532() / 24000.0f + 0.75f), (float)1.0f);
            skyAngleRadian = skyAngle * ((float)Math.PI * 2);
        }
        if ((fs = world.method_28103().method_28109(skyAngle, tickDelta)) != null) {
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.disableTexture();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22903();
            matrices.method_22907(class_1160.field_20703.method_23214(90.0f));
            float i = class_3532.method_15374((float)skyAngleRadian) < 0.0f ? 180.0f : 0.0f;
            matrices.method_22907(class_1160.field_20707.method_23214(i));
            matrices.method_22907(class_1160.field_20707.method_23214(90.0f));
            float j = fs[0];
            float k = fs[1];
            float l = fs[2];
            class_1159 matrix4f = matrices.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
            bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(j, k, l, fs[3] * this.alpha).method_1344();
            for (int n = 0; n <= 16; ++n) {
                float o = (float)n * ((float)Math.PI * 2) / 16.0f;
                float p = class_3532.method_15374((float)o);
                float q = class_3532.method_15362((float)o);
                bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f).method_1344();
            }
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            matrices.method_22909();
        }
        this.renderDecorations(worldRendererAccess, matrices, projectionMatrix, tickDelta, bufferBuilder, this.alpha);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double d = client.field_1724.method_5836((float)tickDelta).field_1351 - world.method_28104().method_28105((class_5539)world);
        if (d < 0.0) {
            matrices.method_22903();
            matrices.method_22904(0.0, 12.0, 0.0);
            worldRendererAccess.getDarkSkyBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
            matrices.method_22909();
        }
        if (world.method_28103().method_28113()) {
            RenderSystem.setShaderColor((float)(f * 0.2f + 0.04f), (float)(g * 0.2f + 0.04f), (float)(h * 0.6f + 0.1f), (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }
}

