/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import io.github.amerebagatelle.fabricskyboxes.SkyboxManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class FabricSkyBoxesConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final GeneralSettings generalSettings = new GeneralSettings();
    private final KeyBindingImpl keyBinding = new KeyBindingImpl();
    private File file;

    public static FabricSkyBoxesConfig load(File file) {
        FabricSkyBoxesConfig config;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (FabricSkyBoxesConfig)GSON.fromJson((Reader)reader, FabricSkyBoxesConfig.class);
            }
            catch (Exception e) {
                FabricSkyBoxesClient.getLogger().error("Could not parse config, falling back to defaults!", (Throwable)e);
                config = new FabricSkyBoxesConfig();
            }
        } else {
            config = new FabricSkyBoxesConfig();
        }
        config.file = file;
        config.save();
        return config;
    }

    public KeyBindingImpl getKeyBinding() {
        return this.keyBinding;
    }

    public void save() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class GeneralSettings {
        public boolean enable = true;
        public int unexpectedTransitionDuration = 20;
        public boolean debugMode = false;
    }

    public static class KeyBindingImpl
    implements ClientTickEvents.EndTick {
        public final class_304 toggleFabricSkyBoxes = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.fabricskyboxes.toggle", class_3675.class_307.field_1668, 320, "category.fabricskyboxes"));

        public void onEndTick(class_310 client) {
            while (this.toggleFabricSkyBoxes.method_1436()) {
                FabricSkyBoxesClient.config().generalSettings.enable = !FabricSkyBoxesClient.config().generalSettings.enable;
                FabricSkyBoxesClient.config().save();
                SkyboxManager.getInstance().setEnabled(FabricSkyBoxesClient.config().generalSettings.enable);
                assert (client.field_1724 != null);
                if (SkyboxManager.getInstance().isEnabled()) {
                    client.field_1724.method_7353((class_2561)new class_2588("fabricskyboxes.message.enabled"), false);
                    continue;
                }
                client.field_1724.method_7353((class_2561)new class_2588("fabricskyboxes.message.disabled"), false);
            }
        }
    }
}

