/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import shcm.shsupercm.fabric.citresewn.cit.ActiveCITs;
import shcm.shsupercm.fabric.citresewn.cit.CITRegistry;
import shcm.shsupercm.fabric.citresewn.config.CITResewnConfig;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyKey;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class CITResewnCommand {
    public static boolean openConfig = false;

    public static void register() {
        ClientCommandManager.DISPATCHER.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"citresewn").executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("CIT Resewn v" + ((ModContainer)FabricLoader.getInstance().getModContainer("citresewn").orElseThrow()).getMetadata().getVersion() + ":")));
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("  Registered: " + CITRegistry.TYPES.values().stream().distinct().count() + " types and " + CITRegistry.CONDITIONS.values().stream().distinct().count() + " conditions")));
            boolean active = CITResewnConfig.INSTANCE.enabled && ActiveCITs.isActive();
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("  Active: " + (String)(active ? "yes" : "no, " + (CITResewnConfig.INSTANCE.enabled ? "no cit packs loaded" : "disabled in config")))));
            if (active) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("   Loaded: " + ActiveCITs.getActive().cits.values().stream().mapToLong(Collection::size).sum() + " CITs from " + ActiveCITs.getActive().cits.values().stream().flatMap(Collection::stream).map(cit -> cit.packName).distinct().count() + " resourcepacks")));
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)""));
            return 1;
        })).then(ClientCommandManager.literal((String)"config").executes(context -> {
            openConfig = true;
            return 1;
        }))).then(ClientCommandManager.literal((String)"analyze").then(ClientCommandManager.literal((String)"pack").then(ClientCommandManager.argument((String)"pack", (ArgumentType)new LoadedCITPackArgument()).executes(context -> {
            String pack = (String)context.getArgument("pack", String.class);
            if (ActiveCITs.isActive()) {
                List conditions;
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)("Analyzed CIT data of \"" + pack + "\u00a7r\":")));
                ArrayList<class_2561> builder = new ArrayList<class_2561>();
                for (Map.Entry entry : ActiveCITs.getActive().globalProperties.properties.entrySet()) {
                    for (PropertyValue value : (Set)entry.getValue()) {
                        if (!value.packName().equals(pack)) continue;
                        builder.add(class_2561.method_30163((String)("  " + ((PropertyKey)entry.getKey()).toString() + (String)(value.keyMetadata() == null ? "" : "." + value.keyMetadata()) + " = " + value.value())));
                    }
                }
                if (!builder.isEmpty()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)" Global Properties:"));
                    for (class_2561 class_25612 : builder) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_25612);
                    }
                    builder.clear();
                }
                for (Map.Entry<Object, Object> entry : ActiveCITs.getActive().cits.entrySet()) {
                    long count;
                    if (((List)entry.getValue()).isEmpty() || (count = ((List)entry.getValue()).stream().filter(cit -> cit.packName.equals(pack)).count()) <= 0L) continue;
                    builder.add(class_2561.method_30163((String)("  " + CITRegistry.idOfType((Class)entry.getKey()).toString() + " = " + count)));
                }
                if (!builder.isEmpty()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)" Types:"));
                    for (class_2561 class_25613 : builder) {
                        ((FabricClientCommandSource)context.getSource()).sendFeedback(class_25613);
                    }
                    builder.clear();
                }
                if (!(conditions = ActiveCITs.getActive().cits.values().stream().flatMap(Collection::stream).filter(cit -> cit.packName.equals(pack)).flatMap(cit -> Arrays.stream(cit.conditions)).toList()).isEmpty()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)(" Utilizing " + conditions.size() + " conditions(" + conditions.stream().map(Object::getClass).distinct().count() + " unique condition types)")));
                }
            } else {
                ((FabricClientCommandSource)context.getSource()).sendFeedback(class_2561.method_30163((String)"Not active"));
            }
            return 1;
        })))));
    }

    private static class LoadedCITPackArgument
    implements ArgumentType<String> {
        private LoadedCITPackArgument() {
        }

        public String parse(StringReader reader) throws CommandSyntaxException {
            StringBuilder builder = new StringBuilder();
            while (reader.canRead()) {
                builder.append(reader.read());
            }
            String pack = builder.toString().trim();
            if (!LoadedCITPackArgument.getPacks().contains(pack)) {
                LiteralMessage message = new LiteralMessage("Could not find CIT pack");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
            }
            return pack;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return CompletableFuture.supplyAsync(() -> {
                for (String pack : LoadedCITPackArgument.getPacks()) {
                    builder.suggest(pack);
                }
                return builder.build();
            });
        }

        private static Set<String> getPacks() {
            if (ActiveCITs.isActive()) {
                return ActiveCITs.getActive().cits.values().stream().flatMap(Collection::stream).map(cit -> cit.packName).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
    }
}

